# Copyright (c) 2017 VMware, Inc.
# All rights reserved. -- VMware Confidential
import os

# NB: Following verstion.txt file isn't packaged with build.
# It will be created after patching once.
__VERSION_FILE__ = '/etc/vmware-syslog/version.txt'


def getSourceVersion(filePath=__VERSION_FILE__):
    ''' Loads current component version from filePath.
    @param filePath: Path to the component version file.
    '''
    version = None
    if os.path.exists(filePath):
        with open(filePath, 'r') as fp:
            version = fp.read()
    return version


def setSourceVersion(version, filePath=__VERSION_FILE__):
    ''' Persists the latest applied patch version.
    @param version: The latest patch version
    @param filePath: Path to the component version file.
    '''
    with open(filePath, 'w') as fp:
        fp.write(version)
