# Copyright (c) 2017-2021 VMware, Inc.  All rights reserved.
# -- VMware Confidential

import logging
import shutil
import simpleXml
from l10n import msgMetadata as _T, localizedString as _

logger = logging.getLogger(__name__)


configXml = "/etc/vmware-rhttpproxy/config.xml"
copy = "/etc/vmware-rhttpproxy/config.tmp1"

def getChanges():
    return _(_T("rhttpproxy.patch1.summary",
                "Unset the 'vmacore/ssl/protocols' config option."))

def changeConfig(filename):
    with open(filename, "r+", encoding="utf-8-sig") as f:
       root = simpleXml.Parse(f.read())
       simpleXml.UnsetPath(root, "vmacore/ssl/protocols")

       f.seek(0)
       f.write(simpleXml.Serialize(root))
       f.truncate()

def doPatching(ctx):
    logger.info("Patch01: being executed {0}".format(ctx))
    changeConfig(configXml)

# Must be used during expand phase of NDU
# We also aim to be revertable
def doExpand(ctx):
    logger.info("Patch01: being executed {0}".format(ctx))

    shutil.copyfile(configXml, copy)

    changeConfig(configXml)

def doRevert(ctx):
    logger.info("Patch01: being reverted {0}".format(ctx))
    shutil.copyfile(copy, configXml)