# Copyright (C) 2020 VMware, Inc.  All rights reserved.
# All rights reserved. -- VMware Confidential
"""
Integration hook for the POD Service

This module integrates the POD service patching scripts with the
vcLCM Non Disruptive Upgrade Framework.
"""

import logging
from extensions import extend, Hook
from patch_specs import PatchContext
import vcsa_utils

logger = logging.getLogger(__name__)

@extend(Hook.Discovery)
def discover(ctx):  # pylint: disable=W0613
    """
    The function indicates that POD service only participates
    in non disruptive upgrade. It also specifies files that need
    to be replicated by the patching framework.

    :param ctx: Context given by the patch framework
    :type ctx: PatchContext
    :return: Return DiscoveryResult.
    :rtype: DiscoveryResult
    """
    logger.info("POD Discovery Hook")

    # Take part only in nondisruptive upgrades
    patchable = ctx.upgradeType == PatchContext.NONDISRUPTIVE_UPGRADE
    replicationConfig = {
        "/var/log/vmware/pod": "/var/log/vmware/pod",
        "/storage/vmware-pod/persistent.state": \
            "/storage/vmware-pod/persistent.state",
        "/etc/vmware-pod/ssl/symkey.dat": "/etc/vmware-pod/ssl/symkey.dat"
    }
    return vcsa_utils.getComponentDiscoveryResult(
                           "pod",
                           patchable=patchable,
                           replicationConfig=replicationConfig)
