#!/usr/bin/env python

#
# Copyright 2021 VMware, Inc.  All rights reserved. -- VMware Confidential
#
'''
This file provides the hooks which will be invoked during patching process.
'''
import logging
import sys
import os

sys.path.append(os.environ['VMWARE_PYTHON_PATH'])

import utils
from cis.defaults import get_component_home_dir

logger = logging.getLogger(__name__)

COMPONENT = 'perfcharts'
PATCH_VERSION = '3'


def doPatching(ctx):
    logger.info("Patching Performance Charts Service")

    '''
    Set perfcharts user permissions for file perfchartsspec.properties &
    perfcharts.properties.
    '''
    cisregSpec = os.path.join(utils.get_config_dir(),
                              'perfchartsspec.properties')
    os.chmod(utils.perfcharts_props_file, 0o700)
    os.chmod(cisregSpec, 0o700)
    # Set perfcharts user perm for catalina_properties & wrapper.conf.
    catalinaProp = os.path.join(utils.get_tc_instance_dir(), 'conf',
                                'catalina.properties')
    os.chmod(catalinaProp, 0o700)
    wrapper = os.path.join(get_component_home_dir(COMPONENT), 'wrapper',
                           'conf', 'wrapper.conf')
    os.chmod(wrapper, 0o600)

    logger.info("Completed patching Performance Chart Service")


def is_patch_needed(prop_file):
    return utils.is_patch_needed(int(PATCH_VERSION), prop_file)


def doExpand(ctx):
    logger.info("No expand for version 3 on perfCharts service")


def doContract(ctx):
    logger.info("No contract for version 3 on perfCharts service")
