#!/usr/bin/env python

#
# Copyright 2019-2021 VMware, Inc.  All rights reserved. -- VMware Confidential
#
"""
Utilities module
"""
import logging
import os
import sys
import shutil

sys.path.append(os.environ['VMWARE_PYTHON_PATH'])

COMPONENT_NAME = 'observability'
OBS_PATCH_KEY = 'observability.patch.version'

logger = logging.getLogger(__name__)


def get_config_dir():
    return '/etc/vmware-%s/config' % COMPONENT_NAME

__PROP_FILE_NAME__ = "observability.properties"
__SOURCE_PROP_FILE_NAME__ = "observability.source.properties"
__PROP_FILE__ = "{0}/{1}".format(get_config_dir(),
                                 __PROP_FILE_NAME__)
__SOURCE_PROP_FILE__ = "{0}/{1}".format(get_config_dir(),
                                        __SOURCE_PROP_FILE_NAME__)


# Preserves observability.properties file (before RPMs are installed)
# by copying to observability.source.properties which could be used in
# pre-start script to distinguish normal & upgrade workflows.
def preserve_prop_file(filePath=__PROP_FILE__,
                       sourceFilePath=__SOURCE_PROP_FILE__):
    from cis.utils import create_dir, write_props_to_file
    if os.path.exists(filePath):
        shutil.copy(filePath, sourceFilePath)
    else:
        logger.info("Version file doesn't exist!! "
                    "This may be a fresh install of Observability")
        create_dir(get_config_dir())
        prop = [(OBS_PATCH_KEY, 0)]
        write_props_to_file(__SOURCE_PROP_FILE__, prop)
