#
# Copyright 2019-2021 VMware, Inc.  All rights reserved. -- VMware Confidential
#
"""PatchRunner integration hook for Observability Vapi Service

This module integrates Observability patching scripts with the
PatchRunner Framework.

"""
__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright 2019-2021 VMware, Inc. All rights reserved.'

import logging

from extensions import extend, Hook
from l10n import msgMetadata as _T, localizedString as _
import vcsa_utils
from . import utils

COMPONENT_NAME = "observability-vapi"

logger = logging.getLogger(__name__)


@extend(Hook.Discovery)
def discover(patch_context):
    logger.info("Executing Discovery Hook for Observability Vapi Service")
    replication_config = {
        "/etc/vmware-observability/config/log4j.properties": None,
        "/etc/vmware-observability/config/log4j-vapi.properties": None,
        "/etc/vmware-observability/config/observability.properties":
        "/etc/vmware-observability/config/observability.source.properties"
    }
    return vcsa_utils.getComponentDiscoveryResult(
        COMPONENT_NAME,
        displayName=_(_T("observability.displayName",
                         "Observability Vapi Service")),
        replicationConfig=replication_config)


@extend(Hook.Expand)
def expand(patch_context):
    logger.info("Executing Expand Hook for Observability")
    if vcsa_utils.isDisruptiveUpgrade(patch_context):
        utils.preserve_prop_file()


@extend(Hook.Patch)
def execute_patch(patch_context):
    # This hook is invoked after the rpms are installed.
    # Logic has been moved to prestart script common for both
    # NDU and in-place upgrade.
    pass
