#!/usr/bin/env python

#
# Copyright 2019-2021 VMware, Inc.  All rights reserved. -- VMware Confidential
#
"""
Patch script that does the following:
Register Lookup service GRPC Endpoints to envoy

"""

import logging
import os
import sys

vmware_python_path = os.getenv('VMWARE_PYTHON_PATH')
if vmware_python_path and os.path.exists(vmware_python_path):
    sys.path.append(vmware_python_path)

logger = logging.getLogger(__name__)

def addEnvoyRoutingForLookupsvc():
    from syncGrpcUtil import addSyncableServiceCluster, addSyncableRouteToLocalService
    try:
        addSyncableServiceCluster("lookupsvc-grpc-cluster" , 4001)
        addSyncableRouteToLocalService("lookupservice", "lookupsvc-grpc-cluster")
    except Exception as e:
        logger.error("Failed to register GRPC endpoints");
        logger.exception(e)

def doPatching(ctx):
    logger.info("Lookup Service patch 2 being executed %s", ctx)
    logger.info("Register LS GRPC Endpoints to Envoy")
    addEnvoyRoutingForLookupsvc()

