# Copyright (c) 2016-2021 VMware, Inc.  All rights reserved.
# VMware Confidential

import logging

import vcsa_utils
from fss_utils import getTargetFSS
from extensions import extend, Hook
logger = logging.getLogger(__name__)

DB_PATH = '/storage/db/vmware-imagebuilder/ib.db'

@extend(Hook.Discovery)
def discover(ctx):
    logger.info('Imagebuilder discovered')

    if getTargetFSS('NDU_Limited_Downtime'):
        logger.info('NDU support enabled. DB will be replicated by the framework')
        # In a backup-restore workflow, we need to backup a "production" DB
        # so we use the sqlite3 utilites for online backup.
        # The NDU framework, however, uses a rsync to sync the DB in a
        # migration-based upgade. rsync finishes off the replication after the
        # services are stopped which means the DB will be up-to-date.
        replicationConfig = {
            DB_PATH: DB_PATH
        }

        result = vcsa_utils.getComponentDiscoveryResult(
            'imagebuilder',
            replicationConfig=replicationConfig
        )

        return result
    else:
        return vcsa_utils.getComponentDiscoveryResult('imagebuilder')
