from cis.defaults import get_cis_config_dir, get_cis_install_dir

from install_common import VCDE_COMPONENT_NAME

CLS_ADMIN_NAME_PREFIX = 'Content library administrator'
CLS_ADMIN_NAME_ID_PREFIX = 'com.vmware.Content.Admin'
CLS_SERVICE_ID_KEY = "cmreg.serviceid"
CONTENT_LIBRARY_CONFIG_HOME = '%s-%s' % (get_cis_config_dir(), VCDE_COMPONENT_NAME)
CONTENT_LIBRARY_HOME = '%s/vmware-%s' % (get_cis_install_dir(), VCDE_COMPONENT_NAME)
CONTENT_LIBRARY_SERVICE_REGISTER_SPEC = CONTENT_LIBRARY_CONFIG_HOME + "/cls_service_cisreg.spec"
CONTENT_LIBRARY_SERVICE_SPEC = CONTENT_LIBRARY_HOME + "/install_lib/regSpecs/vdc_services_spec.json"
KEY_STORE_NAME_MACHINE = "machine"
REVERSE_PROXY_ADDRESS_KEY = "rhttpproxy.endpoint0.address"
REVERSE_PROXY_CONNECTION_TYPE_KEY = "rhttpproxy.endpoint0.connectionType"
REVERSE_PROXY_CONNECTION_TYPE_LOCAL = "local"
SOLUTION_USER_NAME_KEY = "solutionUser.name"
SOLUTION_USER_ID_KEY = "solutionUser.ownerId"
MANAGE_CLUSTER_REGISTRY_PRIVILEGE = "ContentLibrary.ManageClusterRegistryResource"
WCP_KUBERNETES_MANAGER_ROLE_NAME = "vSphereKubernetesManager"
WCP_VMOP_ROLE_NAME = "VMOperatorControllerGlobal"
CLS_REGISTRY_ADMIN_ROLE_NAME_PREFIX = 'Content Library Registry administrator'
CLS_REGISTRY_ADMIN_ROLE_NAME_ID = 'com.vmware.Content.Registry.Admin'
CHECK_OUT_TEMPLATE_PRIVILEGE = "ContentLibrary.CheckOutTemplate"
DOWNLOAD_SESSION_PRIVILEGE = "ContentLibrary.DownloadSession"
SYNC_LIBRARY_PRIVILEGE = "ContentLibrary.SyncLibrary"
SYNC_LIBRARY_ITEM_PRIVILEGE = "ContentLibrary.SyncLibraryItem"
DESIRED_VMOP_PRIVILEGES = [CHECK_OUT_TEMPLATE_PRIVILEGE,
                           DOWNLOAD_SESSION_PRIVILEGE,
                           SYNC_LIBRARY_PRIVILEGE,
                           SYNC_LIBRARY_ITEM_PRIVILEGE]
