# Copyright (c) 2016-2017,2019, 2021-2022 VMware, Inc. All rights reserved.
# VMware Confidential
'''Constants for Content Library B2B and NDU Patching

'''
import os
import sys

__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright 2016-2017,2019, 2021 VMware, Inc. All rights reserved.'

PATCH_VERSION_6_6_8 = '6.6.8'
PATCH_VERSION_6_6_9 = '6.6.9'
PATCH_VERSION_6_7_0 = '6.7.0'

# Content library service name
CLS_SERVICE_NAME = 'content-library'
# Content library config home
CONTENT_LIBRARY_CONFIG_HOME = os.path.join(os.sep, 'etc', 'vmware-content-library')
# Content library config
CLS_CONFIG_DIR = os.path.join(CONTENT_LIBRARY_CONFIG_HOME, 'config')
# Content library home
CONTENT_LIBRARY_HOME = os.path.join(os.sep, 'usr', 'lib', 'vmware-content-library')
# Content library log directory
CLS_LOG_DIR = os.path.join(os.sep, 'var', 'log', 'vmware', 'content-library')
# Pivotal tc Server runtime instance directory on Linux
TC_SERVER_DIR = os.path.join(CONTENT_LIBRARY_HOME, 'server')
# VDC properties file path
VDC_PROPERTIES_FILE = os.path.join(CONTENT_LIBRARY_CONFIG_HOME, 'vdc.properties')
# VDC properties file for replication to target VC, RDU/NDU
VDC_PROPERTIES_FILE_SOURCE = os.path.join(CONTENT_LIBRARY_CONFIG_HOME,
                                          'vdc.properties.source')
# VMTX extension path property
VMTX_EXTENSION_PATH = 'VcServer.vmtxExtensionPaths = vmtx-extension.xml'
# Registry Service extension path property
REGISTRY_EXTENSION_PATH = 'VcServer.registryExtensionPaths = registry-extension.xml'
# Contnt Library services spec
CONTENT_LIBRARY_SERVICE_SPEC = os.path.join(CONTENT_LIBRARY_HOME, 'install_lib',
                                            'regSpecs', 'vdc_services_spec.json')
# Content library service register spec
CONTENT_LIBRARY_SERVICE_REGISTER_SPEC = os.path.join(CONTENT_LIBRARY_CONFIG_HOME,
                                                     'cls_service_cisreg.spec')
# VMTX service VAPI json
VMTX_SERVICE_VAPI_CLI_JSON = os.path.join(CONTENT_LIBRARY_CONFIG_HOME, 'metadata', 'vmtx',
                                          'com.vmware.vcenter.vm_template_cli.json')
# Registry service VAPI json
REGISTRY_SERVICE_VAPI_CLI_JSON = os.path.join(CONTENT_LIBRARY_CONFIG_HOME, 'metadata', 'registry',
                                              'com.vmware.vcenter.content.registries_cli.json')
# VAPI endpoint properties file
VAPI_ENDPOINT_PROPERTIES_FILE = os.path.join(os.sep, 'etc', 'vmware-vapi', 'endpoint.properties')
# Content library trust store file name
CLS_TRUST_STORE_FILE = os.path.join(CONTENT_LIBRARY_CONFIG_HOME, 'truststore.bks')
# Marker file to indicate cls NDU upgrade.
# The file is created at source machine.
CLS_NDU_MARKER_FILE_SOURCE = os.path.join(CLS_CONFIG_DIR, '.cls-ndu-marker-source')
# The CLS NDU marker file is replicated to target machine.
CLS_NDU_MARKER_FILE = os.path.join(CLS_CONFIG_DIR, '.cls-ndu-marker')

# CL PAtch Version File
PATCH_VERSION_FILE = os.path.join(CONTENT_LIBRARY_CONFIG_HOME, 'patch_version.txt')
# CL patch version file source.
PATCH_VERSION_FILE_SOURCE = os.path.join(CONTENT_LIBRARY_CONFIG_HOME, 'patch_version.txt.source')
# Solution user name key
SOLUTION_USER_NAME_KEY = 'solutionUser.name'
# Solution user id key
SOLUTION_USER_ID_KEY = 'solutionUser.ownerId'
# Reverse proxy connection type key
REVERSE_PROXY_CONNECTION_TYPE_KEY = 'rhttpproxy.endpoint0.connectionType'
# Reverse proxy address key
REVERSE_PROXY_ADDRESS_KEY = 'rhttpproxy.endpoint0.address'
# Reverse proxy connection type local
REVERSE_PROXY_CONNECTION_TYPE_LOCAL = 'local'
# key store name machine
KEY_STORE_NAME_MACHINE = 'machine'

# CloudVM components key
CLOUDVM_COMPONENTS_FOR_ID_TRANSLATION = 'cloudvm.components'
# Component name for VMTX
VMTX_TEMPLATE_VAPI_COMPONENT = 'com.vmware.vcenter.vm_template'
# Component name for Registry
REGISTRY_TEMPLATE_VAPI_COMPONENT = 'com.vmware.vcenter.content.registries'

# User & group names
USER_ROOT = 'root'
USER_VAPI_ENDPOINT = 'vapiEndpoint'
USER_CLS = 'content-library'

# Authorization related constants
AUTHZ_TYPE_ID = 'cs.authorization'
CLS_ADMIN_NAME = 'com.vmware.Content.Admin'
EP_AUTHZ_PROTOCOL = 'vmomi'
EP_AUTHZ_TYPE_ID = 'com.vmware.cis.authorization.server'

# Location of content library configuration files
# These configurations should be copied from source
# to destination VC.
CLS_CONFIG_PROP = os.path.join(CLS_CONFIG_DIR, 'cls-config.properties')
CLS_TS_CONFIG_PROP = os.path.join(CLS_CONFIG_DIR, 'ts-config.properties')
CLS_VDCS_CONFIG_PROP = os.path.join(CLS_CONFIG_DIR, 'vdcs-config.properties')
CLS_LOG4J2_PROP = os.path.join(CONTENT_LIBRARY_CONFIG_HOME, 'log4j2.properties')
# Content library configuration file copied to target VC.
CLS_CONFIG_PROP_SOURCE = os.path.join(CLS_CONFIG_DIR, 'cls-config.properties.source')
CLS_TS_CONFIG_PROP_SOURCE = os.path.join(CLS_CONFIG_DIR, 'ts-config.properties.source')
CLS_VDCS_CONFIG_PROP_SOURCE = os.path.join(CLS_CONFIG_DIR, 'vdcs-config.properties.source')
CLS_LOG4J2_PROP_SOURCE = os.path.join(CONTENT_LIBRARY_CONFIG_HOME, 'log4j2.properties.source')
