# Copyright (c) 2021-2022 VMware, Inc. All rights reserved.
# VMware Confidential

from patches.constants import (CLS_NDU_MARKER_FILE, CLS_NDU_MARKER_FILE_SOURCE,
                               CLS_CONFIG_PROP, CLS_CONFIG_PROP_SOURCE,
                               CLS_LOG4J2_PROP, CLS_LOG4J2_PROP_SOURCE,
                               CLS_TS_CONFIG_PROP, CLS_TS_CONFIG_PROP_SOURCE,
                               CLS_VDCS_CONFIG_PROP, CLS_VDCS_CONFIG_PROP_SOURCE,
                               PATCH_VERSION_FILE, PATCH_VERSION_FILE_SOURCE,
                               VDC_PROPERTIES_FILE, VDC_PROPERTIES_FILE_SOURCE)

__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright 2021-2022 VMware, Inc. All rights reserved.'

'''
This replication configuration is used in the NDU upgrade
to override the default replication behaviour defined
in the replication and backup config of any vc component.
'''
replication_config = {
    "/etc/vmware-rhttpproxy/endpoints.conf.d/cls.conf": None,
    "/etc/vmware-content-library/metadata/cls_privilege.xml": None,
    "/etc/vmware-content-library/metadata/cls_role.xml": None,
    CLS_CONFIG_PROP: CLS_CONFIG_PROP_SOURCE,
    CLS_LOG4J2_PROP: CLS_LOG4J2_PROP_SOURCE,
    CLS_NDU_MARKER_FILE_SOURCE: CLS_NDU_MARKER_FILE,
    CLS_TS_CONFIG_PROP: CLS_TS_CONFIG_PROP_SOURCE,
    CLS_VDCS_CONFIG_PROP: CLS_VDCS_CONFIG_PROP_SOURCE,
    PATCH_VERSION_FILE: PATCH_VERSION_FILE_SOURCE,
    VDC_PROPERTIES_FILE: VDC_PROPERTIES_FILE_SOURCE
}
