"""Content Library Patch Exceptions

"""
from l10n import msgMetadata as _T, localizedString as _
from patch_errors import PermanentError

__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright 2016 VMware, Inc. All rights reserved.'


def get_execution_error(more_info=""):
    return PermanentError(_(_T("content-library.patch.execution.error",
                               "Failed to apply Content Library Patch. %s"),
                                more_info))


def get_verification_error(more_info=""):
    more_info = more_info or ""
    return PermanentError(_(_T("content-library.patch.verification.error",
                               "Failed to verify Content Library Patch. %s"),
                               more_info))

