# Copyright 2021 VMware, Inc.  All rights reserved. -- VMware Confidential
# coding: utf-8
import os
import logging

SQL_DIR = os.path.abspath(os.path.join(os.path.dirname(__file__), "sql"))

EXPAND_SQL = "expand.sql"
CONTRACT_SQL = "contract.sql"

__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright 2021 VMware, Inc. All rights reserved.'

logger = logging.getLogger(__name__)


def execute_expand(dbPatchTask):
    ''' Execute the expand phase of the upgrade.
    If there are scripts/sql commands that are already applied it will skip them.
     '''
    logger.info("Expanding database.")
    sql_path = os.path.join(SQL_DIR, EXPAND_SQL)
    dbPatchTask.run_patch_query(sql_path)


def execute_contract(dbPatchTask):
    ''' Execute the contact phase of the upgrade.
    If there are scripts/sql commands that are already applied it will skip them.
     '''
    logger.info("Contracting database.")
    sql_path = os.path.join(SQL_DIR, CONTRACT_SQL)
    dbPatchTask.run_patch_query(sql_path)
