#!/usr/bin/env python

#
# Copyright 2017 VMware, Inc.  All rights reserved. -- VMware Confidential
#
"""
Patch script that does the following:

"""
import logging
import os
import re
import sys
import warnings

vmware_python_path = os.getenv('VMWARE_PYTHON_PATH')
if vmware_python_path and os.path.exists(vmware_python_path):
    sys.path.append(vmware_python_path)

from cis.tools import run_command

logger = logging.getLogger(__name__)

def doPatching(ctx):
    logger.info("CertificateManagement patch: being executed %s", ctx)
    logger.info("Running firstboot operations.")

    # Run FB for certificatemanagement service
    cmd = [os.environ['VMWARE_PYTHON_BIN'],
           '/usr/lib/vmware-certificatemanagement/firstboot/certificatemanagement_firstboot.py',
           '--action',
           'firstboot']
    rc, stdout, stderr = run_command(cmd)
    if rc != 0:
        logger.info("Firstboot operation execution failed")
        logger.info("\n==========STDOUT============\n")
        logger.info(stdout)
        logger.info("\n=========STDERR=============\n")
        logger.info(stderr)
        logger.info("\n============================\n")
        raise Exception("Certificatemanagement Patching failed to execute firstboot operation")
    else:
        logger.info("Successfully ran firstboot operations")
