#
# Copyright 2017-2021 VMware, Inc.  All rights reserved. -- VMware Confidential
#
"""PatchRunner integration hook for CertificateAuthority Service

This module integrates CertificateAuthority patching scripts with the
PatchRunner Framework.

"""
__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright 2019-2021 VMware, Inc. All rights reserved.'

import logging

from extensions import extend, Hook
from l10n import msgMetadata as _T, localizedString as _
import vcsa_utils

COMPONENT_NAME = "certificateauthority"

logger = logging.getLogger(__name__)

@extend(Hook.Discovery)
def discover(patch_context):
    logger.info("Executing Discovery Hook for CertificateAuthority Service")

    replication_config = {
        "/usr/lib/vmware-certificateauthority/config/log4j.properties": None,
    }

    return vcsa_utils.getComponentDiscoveryResult(COMPONENT_NAME,
                                                  displayName=_(
                                                   _T("certificateauthority.displayName",
                                                   "CertificateAuthority Service")),
                                                   replicationConfig=replication_config)


@extend(Hook.Patch)
def execute_patch(patch_context):
    #This hook is invoked after the rpms are installed.
    #logic moved to prestart script
    #common for RDU and B2B
    pass
