# Copyright (c) 2021-2023 VMware, Inc.  All rights reserved.
# All rights reserved. -- VMware Confidential
"""
Integrate applmgmt service with the B2B patching framework
"""
import os
import sys
import logging
import os_utils

from extensions import extend, Hook
from l10n import msgMetadata as _T, localizedString as _
from reporting import getProgressReporter
from vcsa_utils import getComponentDiscoveryResult

logger = logging.getLogger(__name__)


@extend(Hook.Discovery)
def discover(ctx):
    logger.info("Discovering Applmgmt service")
    replicationConfig = {
        "/etc/issue": None,
        "/opt/vmware/etc/lighttpd/lighttpd.conf": None,
        "/etc/applmgmt/appliance/lighttpd.conf": None,
        "/storage/applmgmt/backup_restore/": "/storage/applmgmt/backup_restore/",
        "/etc/applmgmt/appliance/watermark.json" : "/etc/applmgmt/appliance/watermark.json"
    }
    return getComponentDiscoveryResult('applmgmt', replicationConfig=replicationConfig)
