# Copyright 2014 VMware, Inc.  All rights reserved. -- VMware Confidential
'''
Core execution settings. It can be embedded or inherited to provided
extended global settings for distinct functionality, such as first boot
or export.

Example: Retrieving current component name
componentName = getCoreExecutionSettings().componentName

'''

class CoreExecutionSettings:
   '''Holder of common execution settings.
   '''
   # Current upgrade component script.
   componentName = None

   # The current user locale used for translating messages.
   locale = 'en_US'

   # Repository directory if set
   repositoryDirectory = None

   # Repository file name
   repositoryFileName = None

   # If silient install
   silentInstall = False

_globalCoreSettings = CoreExecutionSettings()

def getCoreExecutionSettings():
   '''Gets global core execution settings.

   @return: Instance of CoreExecutionSettings class.
     settings
   '''
   return _globalCoreSettings
