# Copyright 2016 VMware, Inc.  All rights reserved. -- VMware Confidential
#
''' Module containing  globally exposed reporting methods to configure reporting
and get a reporter or StatusAggregator.
'''
import logging

from reporting.reporting_factory import ReportingFactory

logger = logging.getLogger(__name__)

_reportingFactory = None

def getProgressReporter():
    ''' Returns a reporter that is set to report progress messages
    '''
    return getReportingFactory().progressReporter

def getMessageReporter():
    ''' Returns a reporter that is set to report message(info,warning,error) messages
    '''
    return getReportingFactory().messageReporter

def getReportingFactory():
    ''' Get a ReportingFactory that provides several reporters that can report
        messages, questions and progress data . All share a queue and
        use same identifier to identify them.
    '''
    if not _reportingFactory:
        raise ValueError('Reporting has not being initialized.')
    return _reportingFactory
