# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2024 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.cis.data.provider.
#---------------------------------------------------------------------------

"""
The ``com.vmware.cis.data.provider_client`` module provides classes for uniform
data access to the resource model data of a *Data Provider*. The module is
available starting in vSphere 6.5.
**Note:** This module is restricted for **VMware internal use only**.

"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class ResourceModel(VapiInterface):
    """
    Represents a uniform data access interface to the resource model data of a
    *Data Provider*. Provides a convenient API for search and retrieval of
    specific projections on the targeted resource model data. Clients can use
    this interface to navigate through the data provider's inventory using
    filtering by various resource model property criteria. 
    
    Every VMODL2 Data Provider must implement this interface as well as
    :class:`com.vmware.cis.data.provider.metadata_client.Schema` interface. The
    latter is used to advertise the schema of the resource models that could be
    queried.
    **Note:** This class is restricted for **VMware internal use only**.
    """
    PROPERTY_MODEL_KEY = "@modelKey"
    """
    Reserved name for the model key property which identifies the resource for the
    model. Corresponds to the field marked with {\\\\@link \\\\@ModelKey}
    annotation in a VMODL2 model definition. Unlike regular properties, it should
    never be qualified with a resource model name. 

    This property should be used in a
    :attr:`ResourceModel.PropertyPredicate.property` when the intention is to
    search for resource(s) by primary key (ID) or in a
    :attr:`ResourceModel.SortCriterion.property` when the result set should be
    sorted by resource identifier. Also, as any regular property its value could be
    included in the result set for a query if added to the
    :attr:`ResourceModel.QuerySpec.properties` list. This is useful when the client
    wants to determine the resource that the properties of each result item belong
    to.

    """
    PROPERTY_TYPE = "@type"
    """
    Reserved name for the property which identifies the type of the resource model.
    It is equal to the resource type of the \\\\@modelKey identifier. Corresponds
    to the field marked with ``\\\\@Resource`` annotation in a VMODL2 model
    definition. Unlike regular properties, it should never be qualified with a
    resource model name. 

    As any regular property its value could be included in the result set for a
    query if added to the :attr:`ResourceModel.QuerySpec.properties` list..
    **Warning:** This class attribute is part of a new feature in development. It
    may be changed at any time and may not have all supported functionality
    implemented.

    """

    _VAPI_SERVICE_ID = 'com.vmware.cis.data.provider.resource_model'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _ResourceModelStub)
        self._VAPI_OPERATION_IDS = {}

    class QuerySpec(VapiStruct):
        """
        A query which encapsulates a request for specific resource model data. It
        supports filtering the resource model data to return by specifying
        conditions on the targeted resource model properties as well as retrieval
        of arbitrary number of properties or sub-properties of the resource models
        that satisfy the filter criteria. Also, it allows for sorting and limiting
        the final result set. 
        
        Each query has the following main constituents: 
        
        #. Property List: specifies the list of property values to be returned in
           the result set for the query. Corresponds to the ``SELECT`` clause in SQL.
        #. Resource Model List: specifies one or multiple resource models (for the
           same resource type) that should be queried. Corresponds to the ``FROM``
           clause in SQL.
        #. Filter: restricts (filters) the set of resource models whose properties
           should be returned based on conditions/predicates on their property values.
           Corresponds to the ``WHERE`` clause in SQL.
        #. Sort Criteria: defines how the final result set should be sorted by
           comparing the values of one or more properties of the items in the result
           set. Corresponds to the ``ORDER BY`` clause in SQL.
        #. Limit: limits the number of items from the final sorted result set that
           should be returned to the client.
        **Note:** This class is restricted for **VMware internal use only**.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     properties=None,
                     resource_models=None,
                     filter=None,
                     sort_criteria=None,
                     limit=None,
                     offset=None,
                     return_total_count=None,
                    ):
            """
            :type  properties: :class:`list` of :class:`str`
            :param properties: The names of the (resource model) properties to be included in the
                result set for the query. 
                
                Each property name could be either a single property name, in case
                of an immediate property of the resource model or a property path,
                i.e. chain of property names, separated with ``/`` symbol to
                indicate a child property, e.g. ``relatives/father``. 
                
                In case a requested property is present in more than one of the
                queried resource models (specified in
                :attr:`ResourceModel.QuerySpec.resource_models`) the property name
                should be prefixed by the fully-qualified name of the resource
                model of interest, followed by ``/`` symbol before the actual
                property name, e.g. ``com.acme.PersonModel/relatives/father``. 
                
                Corresponds to the ``SELECT`` clause in SQL, where the property
                names correspond to column names. 
                
                The list may be unset only if the
                :attr:`ResourceModel.QuerySpec.limit` is set to zero. Otherwise,
                :class:`com.vmware.vapi.std.errors_client.InvalidArgument` error
                will be thrown.
            :type  resource_models: :class:`list` of :class:`str`
            :param resource_models: The names of the resource models to be queried. All properties used
                in the query should belong to one of those resource models. If a
                property from another model is used somewhere else in the query an
                :class:`com.vmware.vapi.std.errors_client.InvalidArgument` error
                will be thrown to indicate this violation. Multiple resource models
                could be specified here only if they all belong to the same
                resource type. In case multiple resoruce models are specified they
                are implicitly joined on their primary key ``\\\\@modelKey``
                property. 
                
                Each resource model name should be fully-qualified, e.g.
                ``com.acme.PersonModel`` 
                
                Corresponds to the ``FROM`` clause in SQL where the resource models
                correspond to tables. 
                
                The list must not be empty. Otherwise,
                :class:`com.vmware.vapi.std.errors_client.InvalidArgument` error
                will be thrown.
            :type  filter: :class:`ResourceModel.Filter` or ``None``
            :param filter: Restricts (filters) the set of resource models whose properties
                should be returned based on conditions/predicates on their property
                values. 
                
                Corresponds to the ``WHERE`` clause in SQL.
                If unset, the query matches all instances of the resource models
                specified in the :attr:`ResourceModel.QuerySpec.resource_models`
                field (``FROM`` clause).
            :type  sort_criteria: :class:`list` of :class:`ResourceModel.SortCriterion` or ``None``
            :param sort_criteria: Defines how the final result set should be sorted by comparing the
                values of one or more properties of the items in the result set.
                Represents a list of one or more sorting criteria, where those with
                lower indices in the list takes precedence over the specs with
                higher indices. 
                
                Corresponds to the ``ORDER BY`` clause in SQL.
                If unset, no sorting will be applied.
            :type  limit: :class:`long` or ``None``
            :param limit: The maximum number of result items to return. If used, the value
                should be a non-negative integer. 
                
                A limit of zero means that no items shall be retrieved. Useful if
                the client is only interested in the total number of items matched
                by the query; in this case,
                :attr:`ResourceModel.QuerySpec.return_total_count` should be set to
                ``true``, and the ``offset`` should be zero or unset. 
                
                A non-zero limit can be used only if sorting criteria is applied,
                i.e. :attr:`ResourceModel.QuerySpec.sort_criteria` is set. 
                
                Note that the service defines its own default limit that cannot be
                overridden here. If the specified value here is above that limit,
                an :class:`com.vmware.vapi.std.errors_client.InvalidArgument` error
                will be thrown for the particular query in order to indicate this
                violation.
                If unset, a default limit will be automatically assigned.
            :type  offset: :class:`long` or ``None``
            :param offset: The offset into the result set. Could be used only if sorting
                criteria is applied, i.e.
                :attr:`ResourceModel.QuerySpec.sort_criteria` is set. If used, the
                value should be a non-negative integer. 
                
                If the offset is ``N`` and the limit is non-zero, then items from
                ``N`` to ``N + limit - 1`` will be returned. If the limit is 0,
                then the offset should be zero or unset.
                If unset, it will be automatically assigned as 0.
            :type  return_total_count: :class:`bool` or ``None``
            :param return_total_count: Indicates whether the total number of resources that matched the
                query should be computed and returned. This is meaningful only in
                cases where the number of resources that match the query could be
                more than the limit of the result items to be returned as specified
                in :attr:`ResourceModel.QuerySpec.limit`, or if the client wants to
                retrieve only the number of items that matched the query, but
                without the items themselves. If unset, defaults to ``false``. 
                
                The total number of matched resources depends solely on the
                :attr:`ResourceModel.QuerySpec.filter` and the
                :attr:`ResourceModel.QuerySpec.resource_models`. It does not depend
                on the requested :attr:`ResourceModel.QuerySpec.properties`, i.e.
                the total count is similar to but less expressive than the SQL
                ``count`` function. 
                
                **NOTE:** Use this with particular caution and only when it's
                absolutely needed as the computation of this value could have
                noticeable performance overhead.
                If unset, it will be automatically assigned as false.
            """
            self.properties = properties
            self.resource_models = resource_models
            self.filter = filter
            self.sort_criteria = sort_criteria
            self.limit = limit
            self.offset = offset
            self.return_total_count = return_total_count
            VapiStruct.__init__(self)


    QuerySpec._set_binding_type(type.StructType(
        'com.vmware.cis.data.provider.resource_model.query_spec', {
            'properties': type.ListType(type.StringType()),
            'resource_models': type.ListType(type.StringType()),
            'filter': type.OptionalType(type.ReferenceType(__name__, 'ResourceModel.Filter')),
            'sort_criteria': type.OptionalType(type.ListType(type.ReferenceType(__name__, 'ResourceModel.SortCriterion'))),
            'limit': type.OptionalType(type.IntegerType()),
            'offset': type.OptionalType(type.IntegerType()),
            'return_total_count': type.OptionalType(type.BooleanType()),
        },
        QuerySpec,
        False,
        None))


    class Filter(VapiStruct):
        """
        Specifies the filter criteria that each resource model should satisfy in
        order to qualify for the final result set for a given query.
        **Note:** This class is restricted for **VMware internal use only**.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     criteria=None,
                     operator=None,
                    ):
            """
            :type  criteria: :class:`list` of :class:`ResourceModel.PropertyPredicate`
            :param criteria: A set of conditions on the resource model properties that together
                define the criteria for filtering/matching the resources whose data
                to retrieve. 
                
                The list must not be empty. Otherwise,
                :class:`com.vmware.vapi.std.errors_client.InvalidArgument` error
                will be thrown.
            :type  operator: :class:`ResourceModel.Filter.LogicalOperator` or ``None``
            :param operator: The logical operator which defines how the property predicates
                should be combined in order to filter a given resource.
                If unset, defaults to ``AND``.
            """
            self.criteria = criteria
            self.operator = operator
            VapiStruct.__init__(self)


        class LogicalOperator(Enum):
            """
            Truth value operator which depends on multiple conditions (operands). Used
            to filter resources based on more than one condition.

            .. note::
                This class represents an enumerated type in the interface language
                definition. The class contains class attributes which represent the
                values in the current version of the enumerated type. Newer versions of
                the enumerated type may contain new values. To use new values of the
                enumerated type in communication with a server that supports the newer
                version of the API, you instantiate this class. See :ref:`enumerated
                type description page <enumeration_description>`.
            """
            AND = None
            """
            The operator is evaluated to ``true`` only if all its operands are
            ``true``. Otherwise, it evaluates to ``false``.

            """
            OR = None
            """
            The operator is evaluated to ``true`` if at least one of its operands is
            ``true``. Otherwise, it evaluates to ``false``.

            """

            def __init__(self, string):
                """
                :type  string: :class:`str`
                :param string: String value for the :class:`LogicalOperator` instance.
                """
                Enum.__init__(string)

        LogicalOperator._set_values([
            LogicalOperator('AND'),
            LogicalOperator('OR'),
        ])
        LogicalOperator._set_binding_type(type.EnumType(
            'com.vmware.cis.data.provider.resource_model.filter.logical_operator',
            LogicalOperator))

    Filter._set_binding_type(type.StructType(
        'com.vmware.cis.data.provider.resource_model.filter', {
            'criteria': type.ListType(type.ReferenceType(__name__, 'ResourceModel.PropertyPredicate')),
            'operator': type.OptionalType(type.ReferenceType(__name__, 'ResourceModel.Filter.LogicalOperator')),
        },
        Filter,
        False,
        None))


    class PropertyPredicate(VapiStruct):
        """
        A condition on a resource model property. Matches all instances of the
        resource models listed in :attr:`ResourceModel.QuerySpec.resource_models`
        that have a property which satisifes this condition.
        **Note:** This class is restricted for **VMware internal use only**.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """

        _validator_list = [
            UnionValidator(
                'operator',
                {
                    'EQUAL' : [('comparable_value', True)],
                    'NOT_EQUAL' : [('comparable_value', True)],
                    'GREATER' : [('comparable_value', True)],
                    'GREATER_OR_EQUAL' : [('comparable_value', True)],
                    'LESS' : [('comparable_value', True)],
                    'LESS_OR_EQUAL' : [('comparable_value', True)],
                    'LIKE' : [('comparable_value', True)],
                    'NOT_LIKE' : [('comparable_value', True)],
                    'UNSET' : [('comparable_value', True)],
                    'IN' : [('comparable_list', True)],
                    'NOT_IN' : [('comparable_list', True)],
                }
            ),
        ]



        def __init__(self,
                     property=None,
                     operator=None,
                     comparable_value=None,
                     comparable_list=None,
                     array_operator=None,
                     ignore_case=None,
                    ):
            """
            :type  property: :class:`str`
            :param property: Specifies the resource model property to be compared. 
                
                The property name could be either a single property name, in case
                of an immediate property of the resource model or a property path,
                i.e. chain of property names, separated with ``/`` symbol to
                indicate a child property, e.g. ``relatives/father``. 
                
                In case the specified property is present in more than one of the
                queried resource models (specified in
                :attr:`ResourceModel.QuerySpec.resource_models`) the property name
                should be prefixed by the fully-qualified name of the resource
                model of interest, followed by ``/`` symbol before the actual
                property name, e.g. ``com.acme.PersonModel/relatives/father``. 
                
                If the specified property is missing in the queried resource model
                or the property value is unset/null then the respective resource
                items should be excluded from the final result. This exclusion
                should happen for all comparison operators except the
                :attr:`ResourceModel.PropertyPredicate.ComparisonOperator.UNSET`
                operator. The described behavior is the one applied in SQL where
                missing and null values are evaluated to unknown values and all
                predicates on these values do not match any resource.
            :type  operator: :class:`ResourceModel.PropertyPredicate.ComparisonOperator`
            :param operator: The operator to use for comparison of the property value.
            :type  comparable_value: :class:`DataValue`
            :param comparable_value: The primitive value that the property should be compared to. Note
                that only the following primitive value types could be used for
                comparison: 
                
                * integer
                * floating point number
                * boolean
                * string
                
                If any other type is provided,
                :class:`com.vmware.vapi.std.errors_client.InvalidArgument`
                exception will be returned. 
                
                Please, note that when comparing with model key, i.e. property
                :attr:`ResourceModel.PROPERTY_MODEL_KEY`, the comparable value
                should be of string type.
                This attribute is optional and it is only relevant when the value
                of ``operator`` is one of
                :attr:`ResourceModel.PropertyPredicate.ComparisonOperator.EQUAL`,
                :attr:`ResourceModel.PropertyPredicate.ComparisonOperator.NOT_EQUAL`,
                :attr:`ResourceModel.PropertyPredicate.ComparisonOperator.GREATER`,
                :attr:`ResourceModel.PropertyPredicate.ComparisonOperator.GREATER_OR_EQUAL`,
                :attr:`ResourceModel.PropertyPredicate.ComparisonOperator.LESS`,
                :attr:`ResourceModel.PropertyPredicate.ComparisonOperator.LESS_OR_EQUAL`,
                :attr:`ResourceModel.PropertyPredicate.ComparisonOperator.LIKE`,
                :attr:`ResourceModel.PropertyPredicate.ComparisonOperator.NOT_LIKE`,
                or
                :attr:`ResourceModel.PropertyPredicate.ComparisonOperator.UNSET`.
            :type  comparable_list: :class:`list` of :class:`DataValue`
            :param comparable_list: The list of primitive values to test for equality with the property
                value when operator
                :attr:`ResourceModel.PropertyPredicate.ComparisonOperator.IN` or
                :attr:`ResourceModel.PropertyPredicate.ComparisonOperator.NOT_IN`
                is used. The list cannot be empty. 
                
                See :attr:`ResourceModel.PropertyPredicate.comparable_value` for
                the list of allowable primitive value types.
                This attribute is optional and it is only relevant when the value
                of ``operator`` is one of
                :attr:`ResourceModel.PropertyPredicate.ComparisonOperator.IN` or
                :attr:`ResourceModel.PropertyPredicate.ComparisonOperator.NOT_IN`.
            :type  array_operator: :class:`ResourceModel.PropertyPredicate.ArrayOperator` or ``None``
            :param array_operator: The operator should be used only for properties, which return a
                collection as their value. It specifies one of the options defined
                in :class:`ResourceModel.PropertyPredicate.ArrayOperator`. 
                
                This operator MUST always be used in combination with a
                :class:`ResourceModel.PropertyPredicate.ComparisonOperator`.
                MUST be set for collection values and unset for non-collection
                (i.e. scalar) values.
            :type  ignore_case: :class:`bool` or ``None``
            :param ignore_case: Whether to treat lower and upper cases of the same letter as if
                they were the same character. 
                
                If set to ``true``, comparing ``String`` properties will be
                performed while ignoring lower/upper case considerations. That is
                equivalent to performing the search as if before that each property
                was transformed to lower case. 
                
                The default value is ``false``, which means that lower and upper
                case characters are treated as different characters. 
                
                If applied to property of type other than ``String``, an
                ``InvalidArgument`` will be thrown.
                If unset, it will be automatically assigned as false.
            """
            self.property = property
            self.operator = operator
            self.comparable_value = comparable_value
            self.comparable_list = comparable_list
            self.array_operator = array_operator
            self.ignore_case = ignore_case
            VapiStruct.__init__(self)


        class ComparisonOperator(Enum):
            """
            Defines the possible operators to use when comparing the values of
            individual resource model properties. 
            
            When comparing values of different types, one of the values can be promoted
            from one type to another (if needed in order to perform correct comparison)
            according to the following rules: 
            
            * When comparing numeric values, a comparable of type ``long`` could be
              promoted (converted) to type ``double``. The result value will be the same
              as the original value.
            * When comparing to a boolean value, a comparable of type ``string`` can be
              converted to ``boolean`` if the value is parsable to boolean, i.e. either
              *false* or *true* in lower case.

            .. note::
                This class represents an enumerated type in the interface language
                definition. The class contains class attributes which represent the
                values in the current version of the enumerated type. Newer versions of
                the enumerated type may contain new values. To use new values of the
                enumerated type in communication with a server that supports the newer
                version of the API, you instantiate this class. See :ref:`enumerated
                type description page <enumeration_description>`.
            """
            EQUAL = None
            """
            Equality operator.

            """
            NOT_EQUAL = None
            """
            Inequality operator.

            """
            GREATER = None
            """
            Greater than operator. 
            
            Applicable to numerical properties only, e.g. ``long``, ``double``. Cannot
            apply to ``String`` or ``boolean``.

            """
            GREATER_OR_EQUAL = None
            """
            Greater than or equal to operator. 
            
            Applicable to numerical properties only, e.g. ``long``, ``double``. Cannot
            apply to ``String`` or ``boolean``.

            """
            LESS = None
            """
            Less than operator. 
            
            Applicable to numerical properties only, e.g. ``long``, ``double``. Cannot
            apply to ``String`` or ``boolean``.

            """
            LESS_OR_EQUAL = None
            """
            Less than or equal to operator. 
            
            Applicable to numerical properties only, e.g. ``long``, ``double``. Cannot
            apply to ``String`` or ``boolean``.

            """
            IN = None
            """
            Checks for equality with at least one of a list of values 
            
            See :attr:`ResourceModel.PropertyPredicate.comparable_list` for the set of
            the allowable comparable value types.

            """
            NOT_IN = None
            """
            Checks for inequality with all values in a list. If the property is equal
            to any of the values in the list, evaluates to ``false``. Otherwise,
            evaluates to ``true`` and the property is matched. 
            
             See #comparableList for the set of the allowable comparable value types.

            """
            LIKE = None
            """
            Pattern matching operator applicable to ``String`` properties. 
            
            The ``\*`` character is used to define wildcard, i.e. a substitute for zero
            or more missing letters) before or after a given sequence of characters. If
            used at the end, it is interpreted as *search for all properties whose
            value starts with the given characters*. If used at the beginning, it is
            interpreted as *search for all properties whose value ends with the given
            characters*. 
            
            For instance, if the input pattern is *\*vm* it will match property with
            value *linux-vm*, but not *vm-linux*. If the input pattern is *vm\** it
            will match property with value *vm-linux*, but not *linux-vm*. 
            
            The wildcard character cannot be used in between other characters, i.e. in
            the middle of a pattern. It can be use more than once in a single pattern
            only in case it surrounds the pattern, i.e. both in the beginning and at
            the end of the pattern to perform substring (infix) search. 
            
            For instance, if the input pattern is *\*vm\** it will match property with
            value *linux-vm-1*, *linux-vm*, *old-vm-linux*, *vm-linux* and *vm*. 
            
            The backslash character ``\`` is used for escaping. Hence, wildcard is
            escaped with the sequence *\\** and the escape character itself with the
            sequence *\\*.

            """
            NOT_LIKE = None
            """
            Opposite of ``LIKE``. The resource will be matched if the property does NOT
            match the provided pattern.

            """
            UNSET = None
            """
            Checks whether the property has any value assigned to it or not, i.e.
            whether it is unset. Applicable only to optional properties or children of
            optional properties. 
            
            A property is considered unset if its value is ``null`` or its parent
            property is unset. Empty array is not considered unset. 
            
            For instance, the property ``com.acme.PersonModel/phone/home`` is
            considered unset if either it or its parent, i.e.
            ``com.acme.PersonModel/phone`` is equal to ``null``. 
            
            Should be used in conjunction with a ``boolean`` value for
            :attr:`ResourceModel.PropertyPredicate.comparable_value` in order to
            determine whether to look for unset or set property. If ``comparableValue``
            is set to ``true``, matches resources with unset property, Otherwise, if
            ``comparableValue`` is set to ``false``, matches resources whose property
            is set to some (any) value, except ``null``.

            """

            def __init__(self, string):
                """
                :type  string: :class:`str`
                :param string: String value for the :class:`ComparisonOperator` instance.
                """
                Enum.__init__(string)

        ComparisonOperator._set_values([
            ComparisonOperator('EQUAL'),
            ComparisonOperator('NOT_EQUAL'),
            ComparisonOperator('GREATER'),
            ComparisonOperator('GREATER_OR_EQUAL'),
            ComparisonOperator('LESS'),
            ComparisonOperator('LESS_OR_EQUAL'),
            ComparisonOperator('IN'),
            ComparisonOperator('NOT_IN'),
            ComparisonOperator('LIKE'),
            ComparisonOperator('NOT_LIKE'),
            ComparisonOperator('UNSET'),
        ])
        ComparisonOperator._set_binding_type(type.EnumType(
            'com.vmware.cis.data.provider.resource_model.property_predicate.comparison_operator',
            ComparisonOperator))

        class ArrayOperator(Enum):
            """
            Defines the matching algorithm for properties which return collection
            values.

            .. note::
                This class represents an enumerated type in the interface language
                definition. The class contains class attributes which represent the
                values in the current version of the enumerated type. Newer versions of
                the enumerated type may contain new values. To use new values of the
                enumerated type in communication with a server that supports the newer
                version of the API, you instantiate this class. See :ref:`enumerated
                type description page <enumeration_description>`.
            """
            ALL_ELEMENTS = None
            """
            When specified, the #comparableValue is compared against each element in
            the collection with the provided
            :class:`ResourceModel.PropertyPredicate.ComparisonOperator`. 
            
            The resource will be matched if the
            :class:`ResourceModel.PropertyPredicate.ComparisonOperator` returns true
            for ALL elements in the collection, otherwise it will be filtered out. 
            
            If the property is an empty collection or ``null``, the resource is
            matched, no matter the
            :class:`ResourceModel.PropertyPredicate.ComparisonOperator`.

            """
            ANY_ELEMENT = None
            """
            When specified, the #comparableValue is compared against each element in
            the collection with the provided operator
            :class:`ResourceModel.PropertyPredicate.ComparisonOperator`. 
            
            The resource will be matched if the
            :class:`ResourceModel.PropertyPredicate.ComparisonOperator` returns true
            for ANY element in the collection, otherwise it will be filtered out. 
            
            If the property is an empty collection or ``null``, the resource is
            filtered out, no matter the
            :class:`ResourceModel.PropertyPredicate.ComparisonOperator`.

            """

            def __init__(self, string):
                """
                :type  string: :class:`str`
                :param string: String value for the :class:`ArrayOperator` instance.
                """
                Enum.__init__(string)

        ArrayOperator._set_values([
            ArrayOperator('ALL_ELEMENTS'),
            ArrayOperator('ANY_ELEMENT'),
        ])
        ArrayOperator._set_binding_type(type.EnumType(
            'com.vmware.cis.data.provider.resource_model.property_predicate.array_operator',
            ArrayOperator))

    PropertyPredicate._set_binding_type(type.StructType(
        'com.vmware.cis.data.provider.resource_model.property_predicate', {
            'property': type.StringType(),
            'operator': type.ReferenceType(__name__, 'ResourceModel.PropertyPredicate.ComparisonOperator'),
            'comparable_value': type.OptionalType(type.OpaqueType()),
            'comparable_list': type.OptionalType(type.ListType(type.OpaqueType())),
            'array_operator': type.OptionalType(type.ReferenceType(__name__, 'ResourceModel.PropertyPredicate.ArrayOperator')),
            'ignore_case': type.OptionalType(type.BooleanType()),
        },
        PropertyPredicate,
        False,
        None))


    class SortCriterion(VapiStruct):
        """
        Determines how a list of result items should be sorted by the values of one
        or more properties that belong to the models associated with the resources
        that the result items represent.
        **Note:** This class is restricted for **VMware internal use only**.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     property=None,
                     sort_direction=None,
                     ignore_case=None,
                    ):
            """
            :type  property: :class:`str`
            :param property: Specifies the resource model property whose value to compare when
                sorting the result items. 
                
                The property name could be either a single property name, in case
                of an immediate property of the resource model or a property path,
                i.e. chain of property names, separated with ``/`` symbol to
                indicate a child property, e.g. ``relatives/father``. 
                
                In case the specified property is present in more than one of the
                queried resource models (specified in
                :attr:`ResourceModel.QuerySpec.resource_models`) the property name
                should be prefixed by the fully-qualified name of the resource
                model of interest, followed by ``/`` symbol before the actual
                property name, e.g. ``com.acme.PersonModel/relatives/father``. 
                
                If the specified property is missing in the queried resource model
                or the property value is unset/null, then the returned resource
                item should be placed at the end for an ascending order or at the
                beginning for a descending one.
            :type  sort_direction: :class:`ResourceModel.SortCriterion.SortDirection` or ``None``
            :param sort_direction: Specifies the order direction to use when sorting the result items
                by the specified resource model property/properties.
                If unset, defaults to ``ASCENDING``.
            :type  ignore_case: :class:`bool` or ``None``
            :param ignore_case: Whether to treat lower and upper cases of the same letter as if
                they were the same character. 
                
                If set to ``true``, comparing ``String`` properties will be
                performed while ignoring lower/upper case considerations. That is
                equivalent to performing the search as if before that each property
                was transformed to lower case. 
                
                The default value is ``false``, which means that lower and upper
                case characters are treated as different characters. 
                
                If applied to property of type other than ``String``, an
                ``InvalidArgument`` will be thrown.
                If unset, it will be automatically assigned as ``false``.
            """
            self.property = property
            self.sort_direction = sort_direction
            self.ignore_case = ignore_case
            VapiStruct.__init__(self)


        class SortDirection(Enum):
            """
            Defines the possible order directions to use when sorting a list with
            result items.

            .. note::
                This class represents an enumerated type in the interface language
                definition. The class contains class attributes which represent the
                values in the current version of the enumerated type. Newer versions of
                the enumerated type may contain new values. To use new values of the
                enumerated type in communication with a server that supports the newer
                version of the API, you instantiate this class. See :ref:`enumerated
                type description page <enumeration_description>`.
            """
            ASCENDING = None
            """
            Sort the result items in ascending order

            """
            DESCENDING = None
            """
            Sort the result items in descending order

            """

            def __init__(self, string):
                """
                :type  string: :class:`str`
                :param string: String value for the :class:`SortDirection` instance.
                """
                Enum.__init__(string)

        SortDirection._set_values([
            SortDirection('ASCENDING'),
            SortDirection('DESCENDING'),
        ])
        SortDirection._set_binding_type(type.EnumType(
            'com.vmware.cis.data.provider.resource_model.sort_criterion.sort_direction',
            SortDirection))

    SortCriterion._set_binding_type(type.StructType(
        'com.vmware.cis.data.provider.resource_model.sort_criterion', {
            'property': type.StringType(),
            'sort_direction': type.OptionalType(type.ReferenceType(__name__, 'ResourceModel.SortCriterion.SortDirection')),
            'ignore_case': type.OptionalType(type.BooleanType()),
        },
        SortCriterion,
        False,
        None))


    class ResultSet(VapiStruct):
        """
        Contains the data returned in response to a particular query instance.
        **Note:** This class is restricted for **VMware internal use only**.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     properties=None,
                     items=None,
                     total_count=None,
                    ):
            """
            :type  properties: :class:`list` of :class:`str`
            :param properties: The names of the (resource model) properties (as requested in
                :attr:`ResourceModel.QuerySpec.properties`) returned for each
                resource item in the result set. The position (index) of each model
                property in this list corresponds to the position of the model
                property value in each resource item's values list. That is, the
                name of each resource model property in the
                :attr:`ResourceModel.ResourceItem.property_values` list is given by
                the string with the same index (position) in this list. 
                
                Could be empty only in case the
                :attr:`ResourceModel.ResultSet.items` list is empty.
            :type  items: :class:`list` of :class:`ResourceModel.ResourceItem`
            :param items: The list of result items. Each item corresponds to a particular
                resource that matched the conditions in the specified
                :class:`ResourceModel.QuerySpec` instance and containing the
                property data retrieved for that resource. 
                
                Could be empty if no items matched the query.
            :type  total_count: :class:`long` or ``None``
            :param total_count: The total number of resources that matched the query, regardless of
                the actual number that is returned in
                :attr:`ResourceModel.ResultSet.items`.
                This value is set if and only if it has been explicitly requested
                in the query, i.e. if the
                :attr:`ResourceModel.QuerySpec.return_total_count` flag has been
                set to ``true``.
            """
            self.properties = properties
            self.items = items
            self.total_count = total_count
            VapiStruct.__init__(self)


    ResultSet._set_binding_type(type.StructType(
        'com.vmware.cis.data.provider.resource_model.result_set', {
            'properties': type.ListType(type.StringType()),
            'items': type.ListType(type.ReferenceType(__name__, 'ResourceModel.ResourceItem')),
            'total_count': type.OptionalType(type.IntegerType()),
        },
        ResultSet,
        False,
        None))


    class ResourceItem(VapiStruct):
        """
        Contains the data returned for a single resource, which corresponds to a
        single item in the result set. Represents the result of a projection onto
        the public state of the resource model data of the given resource.
        **Note:** This class is restricted for **VMware internal use only**.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     property_values=None,
                    ):
            """
            :type  property_values: :class:`list` of (:class:`DataValue` or ``None``)
            :param property_values: The model property values for the resource. The name of each model
                property value is given by the model property name with the same
                index in :attr:`ResourceModel.ResultSet.properties`. In other
                words, the position of a property value in this list should be the
                same as the position of the property in the
                :attr:`ResourceModel.ResultSet.properties` list.
            """
            self.property_values = property_values
            VapiStruct.__init__(self)


    ResourceItem._set_binding_type(type.StructType(
        'com.vmware.cis.data.provider.resource_model.resource_item', {
            'property_values': type.ListType(type.OptionalType(type.OpaqueType())),
        },
        ResourceItem,
        False,
        None))



    def query(self,
              query_spec,
              ):
        """
        Executes the provided :class:`ResourceModel.QuerySpec` instance, i.e.
        retrieve a snapshot of the resource model data as specified in the
        query.

        :type  query_spec: :class:`ResourceModel.QuerySpec`
        :param query_spec: The query that defines the resource model data to retrieve.
        :rtype: :class:`ResourceModel.ResultSet`
        :return: The resource model data retrieved for the provided query.
        :raise: :class:`com.vmware.vapi.std.errors_client.InvalidArgument` 
            When provided with invalid query specification. See
            :class:`ResourceModel.QuerySpec` for more details.
        :raise: :class:`com.vmware.vapi.std.errors_client.ServiceUnavailable` 
            If the service is too busy or if an external service required for
            the query execution is unavailable or times out, e.g. lost
            connection to DB.
        :raise: :class:`com.vmware.vapi.std.errors_client.Unauthenticated` 
            If a session has not been created, has expired due to inactivity or
            explicit log out.
        """
        return self._invoke('query',
                            {
                            'query_spec': query_spec,
                            })
class _ResourceModelStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for query operation
        query_input_type = type.StructType('operation-input', {
            'query_spec': type.ReferenceType(__name__, 'ResourceModel.QuerySpec'),
        })
        query_error_dict = {
            'com.vmware.vapi.std.errors.invalid_argument':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'InvalidArgument'),
            'com.vmware.vapi.std.errors.service_unavailable':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'ServiceUnavailable'),
            'com.vmware.vapi.std.errors.unauthenticated':
                type.ReferenceType('com.vmware.vapi.std.errors_client', 'Unauthenticated'),

        }
        query_input_value_validator_list = [
        ]
        query_output_validator_list = [
        ]
        query_rest_metadata = None

        operations = {
            'query': {
                'input_type': query_input_type,
                'output_type': type.ReferenceType(__name__, 'ResourceModel.ResultSet'),
                'errors': query_error_dict,
                'input_value_validator_list': query_input_value_validator_list,
                'output_validator_list': query_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'query': query_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.cis.data.provider.resource_model',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=True)


class StubFactory(StubFactoryBase):
    _attrs = {
        'ResourceModel': ResourceModel,
        'metadata': 'com.vmware.cis.data.provider.metadata_client.StubFactory',
    }

