# -*- coding: utf-8 -*-
#---------------------------------------------------------------------------
# Copyright 2024 VMware, Inc.  All rights reserved.

# AUTO GENERATED FILE -- DO NOT MODIFY!
#
# vAPI stub file for package com.vmware.cis.data.provider.metadata.
#---------------------------------------------------------------------------

"""

**Note:** This module is restricted for **VMware internal use only**.

"""

__author__ = 'VMware, Inc.'
__docformat__ = 'restructuredtext en'

import sys

from vmware.vapi.bindings import type
from vmware.vapi.bindings.converter import TypeConverter
from vmware.vapi.bindings.enum import Enum
from vmware.vapi.bindings.error import VapiError
from vmware.vapi.bindings.struct import VapiStruct
from vmware.vapi.bindings.stub import (
    ApiInterfaceStub, StubFactoryBase, VapiInterface)
from vmware.vapi.bindings.common import raise_core_exception
from vmware.vapi.data.validator import (UnionValidator, HasFieldsOfValidator)
from vmware.vapi.exception import CoreException
from vmware.vapi.lib.constants import TaskType
from vmware.vapi.lib.rest import OperationRestMetadata


class Schema(VapiInterface):
    """
    Provides access to the resource model schema of a *Data Provider*. The
    schema describes all resource models supported by the provider as well as
    information about the model properties and how they could be queried. 
    
    This schema describes all resource models that could be queried via the
    :class:`com.vmware.cis.data.provider_client.ResourceModel` interface.
    Hence, any Data Provider that implements the latter must also implement
    this interface in order to expose its resource model schema.
    **Note:** This class is restricted for **VMware internal use only**.
    """

    _VAPI_SERVICE_ID = 'com.vmware.cis.data.provider.metadata.schema'
    """
    Identifier of the service in canonical form.
    """
    def __init__(self, config):
        """
        :type  config: :class:`vmware.vapi.bindings.stub.StubConfiguration`
        :param config: Configuration to be used for creating the stub.
        """
        VapiInterface.__init__(self, config, _SchemaStub)
        self._VAPI_OPERATION_IDS = {}

    class SchemaInfo(VapiStruct):
        """
        Information about the resource model schema of the *Data Provider*. The
        schema describes all resource models supported by the provider as well as
        information about the model properties and how they could be queried.
        **Note:** This class is restricted for **VMware internal use only**.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     models=None,
                    ):
            """
            :type  models: :class:`dict` of :class:`str` and :class:`Schema.ModelInfo`
            :param models: Information about all resource models (e.g.
                ``com.acme.PersonModel``), that could be queried, i.e. used in a
                :class:`com.vmware.cis.data.provider_client.ResourceModel.QuerySpec`
                instance. For each resource model, the properties (e.g. ``name``,
                ``address``) whose values could be retrieved or used in a query
                filter or sort specification are explicitly listed. Cannot be
                empty. 
                
                Represents a map of resource model ``ID`` to a structure that holds
                the information about the model. Cannot be empty.
                When clients pass a value of this class as a parameter, the key in
                the attribute :class:`dict` must be an identifier for the resource
                type: ``com.vmware.vapi.structure``. When methods return a value of
                this class as a return value, the key in the attribute
                :class:`dict` will be an identifier for the resource type:
                ``com.vmware.vapi.structure``.
            """
            self.models = models
            VapiStruct.__init__(self)


    SchemaInfo._set_binding_type(type.StructType(
        'com.vmware.cis.data.provider.metadata.schema.schema_info', {
            'models': type.MapType(type.IdType(), type.ReferenceType(__name__, 'Schema.ModelInfo')),
        },
        SchemaInfo,
        False,
        None))


    class ModelInfo(VapiStruct):
        """
        Information about a particular resource model (e.g.
        ``com.acme.PersonModel``) that could be queried, i.e. used in a
        :class:`com.vmware.cis.data.provider_client.ResourceModel.QuerySpec`
        instance.
        **Note:** This class is restricted for **VMware internal use only**.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     properties=None,
                    ):
            """
            :type  properties: :class:`dict` of :class:`str` and :class:`Schema.PropertyInfo`
            :param properties: Information about all properties of the resource model which could
                be used in a query, i.e.
                :class:`com.vmware.cis.data.provider_client.ResourceModel.QuerySpec`
                instance. If a property of the resource model is not listed here
                than it cannot be used in a query. 
                
                Represents a map of property name to a structure that holds the
                information about the property. Cannot be empty. 
                
                Each property name could be either a single property name, in case
                of an immediate property of the resource model or a property path,
                i.e. chain of property names, separated with ``/`` symbol to
                indicate a child property, e.g. ``parents/father``. 
                
                Only the first-level (root) property of all property paths
                supported for retrieval must be listed in the schema. That means,
                if a schema supports a first level property for retrieval, it also
                supports (for retrieval) each property path that begins with that
                property as root. For example, if a schema contains property
                ``runtime``, then both ``runtime/powerState`` and ``runtime/host``
                are supported for retrieval, even though the schema does not
                explicitly list these property paths. 
                
                In contrast, all property paths that support filtering/sorting must
                be explicitly enumerated in the schema. For example to allow
                filtering/sorting on ``runtime/powerState``, the schema must
                explicitly include ``runtime/powerState``, it is not sufficient to
                include ``runtime``. 
                
                Each property that supports filtering/sorting also supports
                retrieval, i.e. could also be retrieved, hence the following
                *First-level rule* : for every property path which appears in the
                schema, the first-level (root) property must also be in the schema.
                For example, if a schema contains property ``runtime/powerState``,
                it must also contain property ``runtime``.
            """
            self.properties = properties
            VapiStruct.__init__(self)


    ModelInfo._set_binding_type(type.StructType(
        'com.vmware.cis.data.provider.metadata.schema.model_info', {
            'properties': type.MapType(type.StringType(), type.ReferenceType(__name__, 'Schema.PropertyInfo')),
        },
        ModelInfo,
        False,
        None))


    class PropertyInfo(VapiStruct):
        """
        Contains information about a single property of a particular resource model
        that could be used in a query, i.e.
        :class:`com.vmware.cis.data.provider_client.ResourceModel.QuerySpec`
        instance. The value of every property represented by this structure could
        be requested in a query, i.e.
        :attr:`com.vmware.cis.data.provider_client.ResourceModel.QuerySpec.properties`
        field.
        **Note:** This class is restricted for **VMware internal use only**.

        .. tip::
            The arguments are used to initialize data attributes with the same
            names.
        """




        def __init__(self,
                     filterable=None,
                     filterable_by_unset=None,
                     type=None,
                    ):
            """
            :type  filterable: :class:`bool` or ``None``
            :param filterable: Whether the property can be used for resource model filtering and
                result set sorting. There cannot be a property that could be used
                in a filter but not in a sort and vice versa. 
                
                If set to ``false``, the property cannot appear in the filtering
                specification (i.e.
                :attr:`com.vmware.cis.data.provider_client.ResourceModel.PropertyPredicate.property`)
                or the sorting specification (i.e.
                :attr:`com.vmware.cis.data.provider_client.ResourceModel.SortCriterion.property`)
                of any query. However, the property can appear among the requested
                properties for a query (i.e.
                :attr:`com.vmware.cis.data.provider_client.ResourceModel.QuerySpec.properties`).
                If unset, defaults to ``false``.
            :type  filterable_by_unset: :class:`bool` or ``None``
            :param filterable_by_unset: Whether an optional, non-filterable property can be used for
                resource model filtering with operator
                :attr:`com.vmware.cis.data.provider_client.ResourceModel.PropertyPredicate.ComparisonOperator.UNSET`.
                
                If a property is marked filterable, i.e.
                :attr:`Schema.PropertyInfo.filterable` = ``true``, it can be used
                with operator ``UNSET`` just like with any other operator and this
                field should not be set. However, if a property is not filterable,
                e.g. it is a non-leaf property of complex (non-primitve) type,
                still, it could be applicable to operator ``UNSET``. In that case,
                this field should be set to ``true``.
                Must be unset if the property is filterable. Otherwise, it may be
                unset defaulting to ``false``.
            :type  type: :class:`Schema.PropertyInfo.PropertyType` or ``None``
            :param type: The type of the property value. Set only if the property is
                filterable, i.e. :attr:`Schema.PropertyInfo.filterable` is
                ``true``. Otherwise, defaults to ``null``.
                Unset if the property is not filterable.
            """
            self.filterable = filterable
            self.filterable_by_unset = filterable_by_unset
            self.type = type
            VapiStruct.__init__(self)


        class PropertyType(Enum):
            """
            Defines the possible value types of properties that can be used for
            resource filtering and result set sorting, i.e. properties that have
            :attr:`Schema.PropertyInfo.filterable` set to ``true``.

            .. note::
                This class represents an enumerated type in the interface language
                definition. The class contains class attributes which represent the
                values in the current version of the enumerated type. Newer versions of
                the enumerated type may contain new values. To use new values of the
                enumerated type in communication with a server that supports the newer
                version of the API, you instantiate this class. See :ref:`enumerated
                type description page <enumeration_description>`.
            """
            STRING = None
            """
            The property value is of ``string`` type. The value is a variable-length
            sequence of zero or more unicode characters.

            """
            LONG = None
            """
            The property value is of ``long`` type. The value is a 64-bit signed
            integer.

            """
            DOUBLE = None
            """
            The property value is of ``double`` type. The value is a 64-bit floating
            point number.

            """
            BOOLEAN = None
            """
            The property value is of ``boolean`` type. The value is ``true`` or
            ``false``.

            """
            ID = None
            """
            The property value is of ``ID`` type, which references another resource
            model, i.e. foreign key to a
            :attr:`com.vmware.cis.data.provider_client.ResourceModel.PROPERTY_MODEL_KEY`.

            """
            ENUM = None
            """
            The property value is of ``enumerated`` type. The value is one of the named
            values from which the type is composed.

            """

            def __init__(self, string):
                """
                :type  string: :class:`str`
                :param string: String value for the :class:`PropertyType` instance.
                """
                Enum.__init__(string)

        PropertyType._set_values([
            PropertyType('STRING'),
            PropertyType('LONG'),
            PropertyType('DOUBLE'),
            PropertyType('BOOLEAN'),
            PropertyType('ID'),
            PropertyType('ENUM'),
        ])
        PropertyType._set_binding_type(type.EnumType(
            'com.vmware.cis.data.provider.metadata.schema.property_info.property_type',
            PropertyType))

    PropertyInfo._set_binding_type(type.StructType(
        'com.vmware.cis.data.provider.metadata.schema.property_info', {
            'filterable': type.OptionalType(type.BooleanType()),
            'filterable_by_unset': type.OptionalType(type.BooleanType()),
            'type': type.OptionalType(type.ReferenceType(__name__, 'Schema.PropertyInfo.PropertyType')),
        },
        PropertyInfo,
        False,
        None))



    def get(self):
        """
        Information about the resource model schema of the *Data Provider*. The
        schema describes all resource models supported by the provider as well
        as information about the model properties and how they could be
        queried.


        :rtype: :class:`Schema.SchemaInfo`
        :return: The resource model schema of the Data Provider.
        """
        return self._invoke('get', None)
class _SchemaStub(ApiInterfaceStub):
    def __init__(self, config):
        # properties for get operation
        get_input_type = type.StructType('operation-input', {})
        get_error_dict = {}
        get_input_value_validator_list = [
        ]
        get_output_validator_list = [
        ]
        get_rest_metadata = None

        operations = {
            'get': {
                'input_type': get_input_type,
                'output_type': type.ReferenceType(__name__, 'Schema.SchemaInfo'),
                'errors': get_error_dict,
                'input_value_validator_list': get_input_value_validator_list,
                'output_validator_list': get_output_validator_list,
                'task_type': TaskType.NONE,
            },
        }
        rest_metadata = {
            'get': get_rest_metadata,
        }
        ApiInterfaceStub.__init__(
            self, iface_name='com.vmware.cis.data.provider.metadata.schema',
            config=config, operations=operations, rest_metadata=rest_metadata,
            is_vapi_rest=True)


class StubFactory(StubFactoryBase):
    _attrs = {
        'Schema': Schema,
    }

