"""
Copyright 2015-2019 VMware, Inc.  All rights reserved. -- VMware Confidential

This library implements feature state switch.
"""
__author__ = "VMware, Inc"

import os
import sys
import codecs
import logging
import traceback
import datetime
from datetime import datetime


featureNameList = [
    'AddDiscoveredHostToVlcmCluster',
    'AppInfo_ConfigManager',
    'ARCTIC_H5C',
    'ARCTIC_VMWAREID_USER_ACCESS',
    'AssignHwCompositeDev',
    'AssignHwPciLocality',
    'AtlasAgentPlatformGW',
    'atlantic_unstable',
    'AUTH_CSP_VMC_COMMERCIAL',
    'AUTH_STS_CERT_REFRESH',
    'AvsTpmMeasurements',
    'B2B_vmodl0',
    'B2B_vmodl1',
    'B2B_vmodl2',
    'B2B_vmodl3',
    'B2B_vmodl4',
    'BAUHAUS_CLUSTER_STORE',
    'BAUHAUS_HOSTSYNC',
    'batchRenameSupport',
    'BmcAccessLayer',
    'bmcInfo',
    'bnxtnet_unstable',
    'bnxtroce_unstable',
    'brcmfcoe_unstable',
    'CertificateAuthority',
    'CertificateManagement',
    'ClusterConfigManager',
    'ClusterConfigManagerAutoBootstrap',
    'ClusterConfigManagerLive',
    'ClusterConfigManagerTransition',
    'ClusteredEsx_V1',
    'ClusterHclConvergence',
    'ClusterHclDiskDrivesStage2',
    'ClusterHclDiskDrivesStage3',
    'ClusterHclVsanNic',
    'ClusterStore',
    'CL_OVF_Deploy_Optimization',
    'CL_SecurityPolicy',
    'CNS_ALL_SNAPSHOT',
    'CNS_DISABLE_SYNC',
    'CNS_NEW_SYNC',
    'CNS_RELOCATE_VOLUME',
    'CNS_PROP_COLLECTOR_DISPATCHER',
    'CNS_RELOCATE_COLD_VOLUME',
    'ConfigManagerHostAPIs',
    'ConfigStoreStage2',
    'CoreStorage_ConfigMgr',
    'CPU_Scheduler_Info',
    'dataService_pbm',
    'DCF',
    'DeltaMigrationXvc',
    'DistEsxClusterStoreManager',
    'DiskGroupVMC',
    'dnd',
    'DomEpdImprovements',
    'DriverBindParallel',
    'DRS_LB_REASONCODE',
    'DS_FILE_MODIFICATION_UTC',
    'DVX',
    'E2E_4KN',
    'elxnet_unstable',
    'ena_uens_unstable',
    'ena_unstable',
    'entityHealthStatus',
    'EnvoyHostGateway',
    'EnvoyOnESX',
    'EsxApiClients',
    'ESXiLocalUsers',
    'EsxIoAuth',
    'EsxIoMgmt',
    'ESXTelemetryGoldenMetrics',
    'eSwap',
    'ESXConfigEncryptionAPIs',
    'EventsOrdering',
    'FastUpgrade',
    'FastUpgrade_SkipWhitelist',
    'FastUpgrade_Vsan',
    'FCD_CATALOG_HEALTH',
    'FCD_CATALOG_HEALTH_U4',
    'FCD_VRA_SUPPORT',
    'FedRAMP_VCSA',
    'FetchAuditRecords',
    'FileLockInfo_GSS34',
    'fourKnStorageSupport',
    'FT_DRS_METRO_CLUSTER',
    'FT_VBS_SUPPORT',
    'gfms',
    'gosCrashRemediation',
    'Gateway_Observability',
    'GraphicsDRS',
    'guestDetailedData',
    'guestIntegrity',
    'GuestStore_ConfigManager',
    'GuestStore_Stage1',
    'GW_PLATFORM_UPDATE',
    'GW_PLATFORM_NOTIFICATIONS',
    'HAConfigRetry',
    'HAUpgradeStatus',
    'HA_221_SDDC',
    'HA_CleanupDupVMs',
    'HA_Clustering_SVC_V2_APIs',
    'HA_ConfigStore',
    'HA_HostdAwareVMFailover',
    'HBR_FAST_CONSOLIDATE',
    'hbr_nfc',
    'hostAccessManager',
    'hostCertificateManagement',
    'Hostd_Authorization_CS',
    'Hostd_Config_CS',
    'Hostd_SecuritySettings_CS',
    'HostHealth_CS',
    'hostProfiles',
    'hostRemovalCheck',
    'hostVendorSpecificStatus',
    'HPEngineParallel',
    'HPEngineService',
    'HPExtPlugins',
    'HPP_ReservationSupport',
    'hwh',
    'hwh2_0',
    'hwp',
    'HWv20',
    'HWvFuture',
    'HybridApplianceAPI',
    'HybridVC',
    'HybridVC_MultiSDDC_GW',
    'HybridVC_SyncaaS',
    'i40en_unstable',
    'iavmd_unstable',
    'icen_unstable',
    'igbn_unstable',
    'Infravisor',
    'inotify',
    'ionic_en_unstable',
    'irdman_unstable',
    'iser_unstable',
    'ixgben_unstable',
    'KernelModule_ConfigStore',
    'KernelOptions_ConfigStore',
    'KVStore_SecondaryKeys',
    'Langley_Future',
    'liblsuv2_oem_hp_plugin',
    'liblsuv2_oem_lenovo_plugin',
    'LiveUpdate',
    'LLCSched',
    'LowLatencyVMPhase2',
    'lpfc_unstable',
    'LSI2PVSCSI',
    'lsi_mr3_unstable',
    'lsi_msgpt35_unstable',
    'lsi_msgpt3_unstable',
    'LVM_DISKS_FSS',
    'MAAS_GCP_IAM_INTEGRATION',
    'MemoryTiering',
    'multipleCapabilityRequirement',
    'NativeKeyProvider',
    'NativeNVMEVVOLSupport',
    'nativeSnapshot',
    'NDU_Limited_Downtime',
    'NDU_Stable_API',
    'ne1000_unstable',
    'nenic_unstable',
    'NestedPTsInVMKernel',
    'Network_ConfigManager',
    'networkAwareDrs',
    'NfcSessionInfo',
    'NFC_STREAM_OVER_VMOTION',
    'nfnic_unstable',
    'nhpsa_unstable',
    'nmlx4_core_unstable',
    'nmlx4_en_unstable',
    'nmlx4_rdma_unstable',
    'nmlx5_core_unstable',
    'nmlx5_rdma_unstable',
    'nmlxbf_gige_unstable',
    'NsxLiveUpdate',
    'NSX_Integrated',
    'nsx_uens_u2',
    'nsx_uens_default',
    'ntg3_unstable',
    'nvmerdma_unstable',
    'NVMeVVols3_VASA4',
    'nvme_pcie_unstable',
    'nvme_stats',
    'nvmxnet3_unstable',
    'ocmSupportedForReconfigure',
    'PANDORA_REMOVAL',
    'pbmDataProvider',
    'pciDeviceExt',
    'pciDpcQuirks',
    'pcieDirectP2P',
    'pciSriovExtendedID',
    'pciSriovPerDeviceMaxVfs',
    'PersonalityManagerDepotDeletion',
    'PersonalityManagerErrorReport',
    'PersonalityManagerESXio',
    'PersonalityManagerFDAwareSolutionApply',
    'PersonalityManagerHWCapabilityModule',
    'PersonalityManagerRecoEngineStage2',
    'PersonalityManagerSoftwareInternalTest',
    'PersonalityManagerSoftwareSolutions',
    'PersonalityManagerSoftwareSolutionsNsx',
    'PersonalityManagerStage2',
    'PersonalityManagerStagingV1',
    'PersonalityManagerVMC',
    'PersonalityManagerVMC_Witness',
    'Pktcap_RCF',
    'PMemDLC',
    'PMemHA_V1',
    'PMemIndepSnapshot',
    'PMemV2',
    'pmem_nfc',
    'PodVMOnVDS',
    'policyIntrospect',
    'POSIXDomainSockets',
    'pr1429825',
    'pr1803450',
    'profileDetails',
    'ProvisioningEventRefresh',
    'qcnic_unstable',
    'qedentv_unstable',
    'qedi',
    'qedf',
    'qedrntv_unstable',
    'qfle3f_unstable',
    'qfle3i_unstable',
    'qfle3_unstable',
    'qflge_unstable',
    'qlnativefc_unstable',
    'queryAllProviders',
    'QuickBoot_TPM',
    'QuickLaunch_Drivers',
    'QuickLaunch_KernelPreload',
    'RbdCustomHostCerts',
    'rdmahl_unstable',
    'RDU_LVM_Integration',
    'RebootReasonTool',
    'RelationshipManager',
    'resetportstatistics',
    'sandboxd_cps',
    'SEV_SNP',
    'sfvmk_unstable',
    'SGX_MPA_HostReg',
    'SGX_MPA_VMCheck',
    'SHA256_Mode',
    'smartnic_network',
    'smartnic_vc',
    'smartpqi_unstable',
    'smsInfrastructure',
    'SoftNUMA',
    'spbmApplyProfileExt',
    'SPBM_DISK_PROV_VIA_POLICY',
    'spbmFetchEntityHealthStatusExt',
    'spbmHCIMeshIntegration',
    'spbmParameterizedProfiles',
    'SpsDebugAPIs',
    'SRE_Health',
    'SRIOVValidNumVFs',
    'StatsStreaming',
    'STSMultitoken',
    'SvcAccountMgmt',
    'TaggingPluginForIPM',
    'TDX',
    'ThunderPciDevices',
    'ThunderPciDevices_TKG_PassThrough',
    'TimeSysCRX',
    'toolsOffHost',
    'Tools_Update_Health',
    'TLSCertSubscription',
    'TrustAuthority_V4',
    'TrustManagement',
    'UPITHostCapability',
    'USB_NIC',
    'USB_PTSwitch_ConfigManager',
    'UserLevelMonitor',
    'VADP_NVMEQuiescedSnapshot',
    'VapiPowerSvc',
    'VAPI_PROVIDER_FILE_REG',
    'VAPI_TAGGING_SPBM',
    'VASA_TargetGroupName',
    'vcAgnosticCompatCheck',
    'VCDP_NestedFilters',
    'VCDP_SmartSearch',
    'VCLS_DatastoreReconfigure',
    'VCProfiles_Apply_DS',
    'VCProfiles_UI_ConfigMgmt',
    'VCProfilesVsphereUiConfig',
    'VCSA_CONTAINERS',
    'VCSA_Hardening',
    'VCSA_WS1_CONTAINERS',
    'VCSA_WS1_INTEGRATION',
    'VCSASideCarProxy',
    'VCSOF_173',
    'VC_EnableSsoResilienceFlag',
    'VC_FIPS',
    'VC_FIPS_SIDECAR',
    'VC_JAVA_FIPS',
    'VC_TICKET_AUTH_FILE_TRANSFER',
    'VC_VAPI_GuestCustomization2',
    'VC_VAPI_JavaShimRemoval1',
    'VCM',
    'VCReportMissingPrivileges',
    'VCReportRequestedPrivileges',
    'vdcs',
    'vdtc_esx',
    'vdtc_esx_core',
    'vdtc_hostd',
    'vdtc_pyVmomi_client',
    'vdtc_vpxa',
    'VFlash_Removal',
    'vHT',
    'VirtualTopo',
    'VLCM_HA_NewLockingStrategy',
    'VLCM_RevisedLockingStrategy',
    'VLCM_TelemetryErrorSupport',
    'VMAFD_ESX',
    'VmcExternalStorageSupport',
    'VMCG_AUTO_UPDATE',
    'VmciMultiArch',
    'vmcManagementProfile',
    'vmcps',
    'VMK_USB_3_2_SPEC_COMPLIANCE',
    'Vmkapps_ConfigManager',
    'Vmkapps_ConfigManagerAdvCfg',
    'Vmkapps_ConfigManagerAdvCfgStage2',
    'Vmkapps_ConfigManagerPTP',
    'Vmkapps_ConfigManagerScratchConfig',
    'Vmkapps_ConfigManagerSsh',
    'Vmkapps_ConfigManagerStage2',
    'Vmkapps_ConfigManagerSyslog',
    'Vmkapps_snmpv3LK',
    'Vmkapps_timecfg',
    'VMcrypt3_KeyCustomAttribute',
    'VMcryptNext',
    'VMcrypt_IntegrityProtection',
    'VMcrypt_OnlineVMEncryption',
    'VMcrypt_V4',
    'VMDIR_SimplifiedReplication',
    'VMIOP_DEVICE_HANDOFF',
    'VMIOP_MIGRATE_PRECOPY',
    'vMMR',
    'vmknvmevvol',
    'vmknvme_enhance_iosplit',
    'vmksdhci',
    'vmMisc',
    'VMNameSpace',
    'VMODL_FSS',
    'VMODL_JOAP_VMOMI',
    'vmodlVasaDataService',
    'vmodlvsanVpxd',
    'vmsyslogd2',
    'VMWARE_B2B',
    'vmw_ahci_unstable',
    'VMXStats',
    'vmxnet3UPT',
    'VM_CLONE_SWITCH_HOST_EMM',
    'VM_Customization_Cloudinit_Data',
    'VM_Customization_Telemetry',
    'VM_OP_NOTIFICATION_TO_APP',
    'VNVME_Clustering',
    'VQAT',
    'VRDMA_ASYNC_POST',
    'VSAN2_AwareDrs',
    'VSAN2_CLOM',
    'VSAN2_DOM',
    'VSAN2_Encryption',
    'VSAN2_NativeSnapshot',
    'VSAN2_Policy',
    'VSAN2_SingleTier',
    'VSAN2_Compression',
    'VSAN2_Configure',
    'vsanAssociation',
    'vsanHealthInCompliance',
    'vsanObjectSupport',
    'VSAN_CMMDS_ARENA_COMPRESSION',
    'VSAN_DOM_OWNER_REBALANCE',
    'VSAN_ComputeOnlyClient',
    'VSAN_ConfigManager',
    'VSAN_CoreDump',
    'VSAN_CRYPTO_SG_API',
    'VSAN_DeltaCompEnsureDurability',
    'VSAN_DEV_MODE',
    'VSAN_DgBasedReplication',
    'VSAN_DIRECT_CAP_POLICY',
    'VSAN_DIRECT_COMPUTE_ONLY_CLUSTER',
    'VSAN_DIRECT_DISK_DECOMMISSION',
    'VSAN_DIRECT_DISK_DECOM_E2E',
    'VSAN_DPAP',
    'VSAN_DPRP',
    'VSAN_DPRP_EBS',
    'VSAN_ENHANCED_URE_HANDLING',
    'VSAN_FASTBOOT_V2',
    'VSAN_FILEANALYTICS',
    'VSAN_FILESERVICE_AV',
    'VSAN_FILESERVICE_CRX',
    'VSAN_FILESERVICE_HOMEDIR',
    'VSAN_FILESERVICE_KRB',
    'VSAN_FILESERVICE_REPLICATION',
    'VSAN_FILESERVICE_SHM',
    'VSAN_FILESERVICE_SMB',
    'VSAN_HARDWARE_MGMT',
    'VSAN_HISTORICAL_HEALTH_REPORT',
    'VSAN_MANAGED_PMEM',
    'VSAN_MetadataElasticPolicy',
    'VSAN_OBJ_HEALTH_V2',
    'VSAN_ObjectScrubConfig',
    'VSAN_RdmaStretchedClusterSupport',
    'VSAN_RDT_MUX2',
    'VSAN_REBUILD_TRIM',
    'VSAN_SiteResiliency',
    'VSAN_UNANIMOUS_DECISION',
    'VSAN_UnplannedDelta',
    'VSAN_V1_METADATA_RESILIENCY',
    'VSAN_VCG_NOTIFICATION',
    'VSAN_VMCP',
    'VSAN_VpPlugin',
    'VSAN_WITNESS_UPGRADE',
    'VSAN_ZDOM',
    'VslmStats',
    'VSPHERE_DP',
    'VSPHERE_DP_CODRAAS',
    'VSPHERE_FD',
    'VSTATS',
    'VSTATS_SRE_HEALTH',
    'VSTATS_VCSA_STORAGE_PROVIDERS',
    'vVol_datastore_scalability',
    'WCP_AppPlatform_InstallAPI',
    'WCP_AppPlatform_Upgrade',
    'WCP_AppPlatform_VcUiPlugins_Per_Cluster',
    'WCP_CNS_File_Volume',
    'WCP_DHCP',
    'WCP_Enable_V2',
    'WCP_Enablement_Improvements',
    'WCP_FaultDomains',
    'WCP_GuestCluster',
    'WCP_GuestCluster_Antrea',
    'WCP_GuestCluster_NCP',
    'WCP_GuestCluster_Update',
    'WCP_GuestCluster_VCUI_Plugin',
    'WCP_Instance_Storage',
    'WCP_Integrated_AVI',
    'WCP_Namespace_Network_Settings',
    'WCP_Namespace_SelfService',
    'WCP_Namespace_SelfService_Manage',
    'WCP_NSX_Security_Policy',
    'WCP_Observability_Logging',
    'WCP_Pinniped_Integration',
    'WCP_PMAN',
    'WCP_PSP_ResourceCheck',
    'WCP_Subscription_Licensing',
    'WCP_Tanzu_Scale_Licensing',
    'WCP_T1_PerNamespace',
    'WCP_TMC_Proxy_Support',
    'WCP_USE_VNVME_IN_POD_VM',
    'WCP_VDPP_EMM_Improvements',
    'WCP_VMC',
    'WCP_VMC_PodVM',
    'WCP_VMService',
    'WCP_VMService_v1alpha2',
    'WCP_VMService_VMC',
    'WCP_VMService_NamespaceTemplate',
    'WCP_Workload_On_Vsphere_Networking_Avi',
    'WCP_Workload_On_Vsphere_Networking_Day_Two',
    'WCP_Workload_On_Vsphere_Networking_Upgrade',
    'webRemoteDevice',
    'webmks',
    'XVC_Workflow_Security',
]

AddDiscoveredHostToVlcmCluster = True
AppInfo_ConfigManager = True
ARCTIC_H5C = True
ARCTIC_VMWAREID_USER_ACCESS = False
AssignHwCompositeDev = False
AssignHwPciLocality = False
AtlasAgentPlatformGW = True
atlantic_unstable = False
AUTH_CSP_VMC_COMMERCIAL = False
AUTH_STS_CERT_REFRESH = False
AvsTpmMeasurements = False
B2B_vmodl0 = False
B2B_vmodl1 = False
B2B_vmodl2 = False
B2B_vmodl3 = False
B2B_vmodl4 = False
BAUHAUS_CLUSTER_STORE = False
BAUHAUS_HOSTSYNC = False
batchRenameSupport = False
BmcAccessLayer = False
bmcInfo = False
bnxtnet_unstable = False
bnxtroce_unstable = False
brcmfcoe_unstable = False
CertificateAuthority = True
CertificateManagement = True
ClusterConfigManager = False
ClusterConfigManagerAutoBootstrap = False
ClusterConfigManagerLive = False
ClusterConfigManagerTransition = False
ClusteredEsx_V1 = False
ClusterHclConvergence = False
ClusterHclDiskDrivesStage2 = True
ClusterHclDiskDrivesStage3 = False
ClusterHclVsanNic = False
ClusterStore = False
CL_OVF_Deploy_Optimization = True
CL_SecurityPolicy = True
CNS_ALL_SNAPSHOT = True
CNS_DISABLE_SYNC = False
CNS_NEW_SYNC = False
CNS_RELOCATE_VOLUME = True
CNS_PROP_COLLECTOR_DISPATCHER = False
CNS_RELOCATE_COLD_VOLUME = True
ConfigManagerHostAPIs = False
ConfigStoreStage2 = True
CoreStorage_ConfigMgr = False
CPU_Scheduler_Info = False
dataService_pbm = False
DCF = False
DeltaMigrationXvc = False
DistEsxClusterStoreManager = False
DiskGroupVMC = False
dnd = False
DomEpdImprovements = True
DriverBindParallel = False
DRS_LB_REASONCODE = False
DS_FILE_MODIFICATION_UTC = False
DVX = False
E2E_4KN = False
elxnet_unstable = False
ena_uens_unstable = False
ena_unstable = False
entityHealthStatus = False
EnvoyHostGateway = False
EnvoyOnESX = False
EsxApiClients = False
ESXiLocalUsers = False
EsxIoAuth = False
EsxIoMgmt = False
ESXTelemetryGoldenMetrics = False
eSwap = False
ESXConfigEncryptionAPIs = True
EventsOrdering = False
FastUpgrade = True
FastUpgrade_SkipWhitelist = False
FastUpgrade_Vsan = True
FCD_CATALOG_HEALTH = False
FCD_CATALOG_HEALTH_U4 = False
FCD_VRA_SUPPORT = False
FedRAMP_VCSA = False
FetchAuditRecords = True
FileLockInfo_GSS34 = False
fourKnStorageSupport = False
FT_DRS_METRO_CLUSTER = False
FT_VBS_SUPPORT = False
gfms = False
gosCrashRemediation = False
Gateway_Observability = True
GraphicsDRS = False
guestDetailedData = False
guestIntegrity = False
GuestStore_ConfigManager = True
GuestStore_Stage1 = True
GW_PLATFORM_UPDATE = True
GW_PLATFORM_NOTIFICATIONS = False
HAConfigRetry = True
HAUpgradeStatus = False
HA_221_SDDC = False
HA_CleanupDupVMs = False
HA_Clustering_SVC_V2_APIs = False
HA_ConfigStore = True
HA_HostdAwareVMFailover = True
HBR_FAST_CONSOLIDATE = False
hbr_nfc = False
hostAccessManager = False
hostCertificateManagement = False
Hostd_Authorization_CS = True
Hostd_Config_CS = True
Hostd_SecuritySettings_CS = True
HostHealth_CS = False
hostProfiles = False
hostRemovalCheck = False
hostVendorSpecificStatus = False
HPEngineParallel = False
HPEngineService = False
HPExtPlugins = False
HPP_ReservationSupport = False
hwh = False
hwh2_0 = False
hwp = False
HWv20 = False
HWvFuture = False
HybridApplianceAPI = False
HybridVC = True
HybridVC_MultiSDDC_GW = False
HybridVC_SyncaaS = True
i40en_unstable = False
iavmd_unstable = False
icen_unstable = False
igbn_unstable = False
Infravisor = False
inotify = False
ionic_en_unstable = False
irdman_unstable = False
iser_unstable = False
ixgben_unstable = False
KernelModule_ConfigStore = False
KernelOptions_ConfigStore = False
KVStore_SecondaryKeys = True
Langley_Future = False
liblsuv2_oem_hp_plugin = False
liblsuv2_oem_lenovo_plugin = True
LiveUpdate = False
LLCSched = True
LowLatencyVMPhase2 = True
lpfc_unstable = False
LSI2PVSCSI = False
lsi_mr3_unstable = False
lsi_msgpt35_unstable = False
lsi_msgpt3_unstable = False
LVM_DISKS_FSS = False
MAAS_GCP_IAM_INTEGRATION = False
MemoryTiering = False
multipleCapabilityRequirement = False
NativeKeyProvider = True
NativeNVMEVVOLSupport = False
nativeSnapshot = False
NDU_Limited_Downtime = True
NDU_Stable_API = False
ne1000_unstable = False
nenic_unstable = False
NestedPTsInVMKernel = False
Network_ConfigManager = False
networkAwareDrs = False
NfcSessionInfo = True
NFC_STREAM_OVER_VMOTION = False
nfnic_unstable = False
nhpsa_unstable = False
nmlx4_core_unstable = False
nmlx4_en_unstable = False
nmlx4_rdma_unstable = False
nmlx5_core_unstable = False
nmlx5_rdma_unstable = False
nmlxbf_gige_unstable = False
NsxLiveUpdate = False
NSX_Integrated = False
nsx_uens_u2 = False
nsx_uens_default = False
ntg3_unstable = False
nvmerdma_unstable = False
NVMeVVols3_VASA4 = False
nvme_pcie_unstable = False
nvme_stats = False
nvmxnet3_unstable = False
ocmSupportedForReconfigure = False
PANDORA_REMOVAL = False
pbmDataProvider = False
pciDeviceExt = False
pciDpcQuirks = False
pcieDirectP2P = True
pciSriovExtendedID = False
pciSriovPerDeviceMaxVfs = False
PersonalityManagerDepotDeletion = True
PersonalityManagerErrorReport = True
PersonalityManagerESXio = False
PersonalityManagerFDAwareSolutionApply = True
PersonalityManagerHWCapabilityModule = False
PersonalityManagerRecoEngineStage2 = True
PersonalityManagerSoftwareInternalTest = False
PersonalityManagerSoftwareSolutions = True
PersonalityManagerSoftwareSolutionsNsx = True
PersonalityManagerStage2 = False
PersonalityManagerStagingV1 = False
PersonalityManagerVMC = True
PersonalityManagerVMC_Witness = True
Pktcap_RCF = True
PMemDLC = False
PMemHA_V1 = True
PMemIndepSnapshot = True
PMemV2 = False
pmem_nfc = False
PodVMOnVDS = False
policyIntrospect = False
POSIXDomainSockets = True
pr1429825 = False
pr1803450 = False
profileDetails = False
ProvisioningEventRefresh = False
qcnic_unstable = False
qedentv_unstable = False
qedi = False
qedf = False
qedrntv_unstable = False
qfle3f_unstable = False
qfle3i_unstable = False
qfle3_unstable = False
qflge_unstable = False
qlnativefc_unstable = False
queryAllProviders = False
QuickBoot_TPM = False
QuickLaunch_Drivers = False
QuickLaunch_KernelPreload = True
RbdCustomHostCerts = False
rdmahl_unstable = False
RDU_LVM_Integration = True
RebootReasonTool = True
RelationshipManager = False
resetportstatistics = False
sandboxd_cps = False
SEV_SNP = False
sfvmk_unstable = False
SGX_MPA_HostReg = False
SGX_MPA_VMCheck = False
SHA256_Mode = False
smartnic_network = False
smartnic_vc = False
smartpqi_unstable = False
smsInfrastructure = False
SoftNUMA = False
spbmApplyProfileExt = True
SPBM_DISK_PROV_VIA_POLICY = False
spbmFetchEntityHealthStatusExt = True
spbmHCIMeshIntegration = False
spbmParameterizedProfiles = False
SpsDebugAPIs = False
SRE_Health = False
SRIOVValidNumVFs = False
StatsStreaming = False
STSMultitoken = True
SvcAccountMgmt = True
TaggingPluginForIPM = False
TDX = False
ThunderPciDevices = True
ThunderPciDevices_TKG_PassThrough = True
TimeSysCRX = True
toolsOffHost = False
Tools_Update_Health = False
TLSCertSubscription = False
TrustAuthority_V4 = False
TrustManagement = True
UPITHostCapability = False
USB_NIC = False
USB_PTSwitch_ConfigManager = True
UserLevelMonitor = False
VADP_NVMEQuiescedSnapshot = False
VapiPowerSvc = False
VAPI_PROVIDER_FILE_REG = True
VAPI_TAGGING_SPBM = False
VASA_TargetGroupName = False
vcAgnosticCompatCheck = False
VCDP_NestedFilters = False
VCDP_SmartSearch = False
VCLS_DatastoreReconfigure = True
VCProfiles_Apply_DS = True
VCProfiles_UI_ConfigMgmt = False
VCProfilesVsphereUiConfig = False
VCSA_CONTAINERS = False
VCSA_Hardening = False
VCSA_WS1_CONTAINERS = False
VCSA_WS1_INTEGRATION = False
VCSASideCarProxy = False
VCSOF_173 = False
VC_EnableSsoResilienceFlag = False
VC_FIPS = True
VC_FIPS_SIDECAR = True
VC_JAVA_FIPS = True
VC_TICKET_AUTH_FILE_TRANSFER = True
VC_VAPI_GuestCustomization2 = True
VC_VAPI_JavaShimRemoval1 = False
VCM = False
VCReportMissingPrivileges = False
VCReportRequestedPrivileges = False
vdcs = False
vdtc_esx = False
vdtc_esx_core = True
vdtc_hostd = True
vdtc_pyVmomi_client = False
vdtc_vpxa = True
VFlash_Removal = False
vHT = False
VirtualTopo = False
VLCM_HA_NewLockingStrategy = True
VLCM_RevisedLockingStrategy = True
VLCM_TelemetryErrorSupport = False
VMAFD_ESX = False
VmcExternalStorageSupport = False
VMCG_AUTO_UPDATE = True
VmciMultiArch = False
vmcManagementProfile = False
vmcps = False
VMK_USB_3_2_SPEC_COMPLIANCE = False
Vmkapps_ConfigManager = False
Vmkapps_ConfigManagerAdvCfg = False
Vmkapps_ConfigManagerAdvCfgStage2 = False
Vmkapps_ConfigManagerPTP = True
Vmkapps_ConfigManagerScratchConfig = False
Vmkapps_ConfigManagerSsh = False
Vmkapps_ConfigManagerStage2 = False
Vmkapps_ConfigManagerSyslog = True
Vmkapps_snmpv3LK = False
Vmkapps_timecfg = True
VMcrypt3_KeyCustomAttribute = False
VMcryptNext = False
VMcrypt_IntegrityProtection = False
VMcrypt_OnlineVMEncryption = False
VMcrypt_V4 = False
VMDIR_SimplifiedReplication = False
VMIOP_DEVICE_HANDOFF = True
VMIOP_MIGRATE_PRECOPY = True
vMMR = True
vmknvmevvol = False
vmknvme_enhance_iosplit = False
vmksdhci = False
vmMisc = False
VMNameSpace = False
VMODL_FSS = False
VMODL_JOAP_VMOMI = False
vmodlVasaDataService = False
vmodlvsanVpxd = False
vmsyslogd2 = False
VMWARE_B2B = False
vmw_ahci_unstable = False
VMXStats = False
vmxnet3UPT = False
VM_CLONE_SWITCH_HOST_EMM = False
VM_Customization_Cloudinit_Data = True
VM_Customization_Telemetry = True
VM_OP_NOTIFICATION_TO_APP = True
VNVME_Clustering = False
VQAT = False
VRDMA_ASYNC_POST = False
VSAN2_AwareDrs = False
VSAN2_CLOM = False
VSAN2_DOM = False
VSAN2_Encryption = False
VSAN2_NativeSnapshot = False
VSAN2_Policy = False
VSAN2_SingleTier = False
VSAN2_Compression = False
VSAN2_Configure = False
vsanAssociation = False
vsanHealthInCompliance = False
vsanObjectSupport = False
VSAN_CMMDS_ARENA_COMPRESSION = False
VSAN_DOM_OWNER_REBALANCE = True
VSAN_ComputeOnlyClient = True
VSAN_ConfigManager = False
VSAN_CoreDump = False
VSAN_CRYPTO_SG_API = False
VSAN_DeltaCompEnsureDurability = False
VSAN_DEV_MODE = False
VSAN_DgBasedReplication = True
VSAN_DIRECT_CAP_POLICY = False
VSAN_DIRECT_COMPUTE_ONLY_CLUSTER = False
VSAN_DIRECT_DISK_DECOMMISSION = True
VSAN_DIRECT_DISK_DECOM_E2E = True
VSAN_DPAP = False
VSAN_DPRP = False
VSAN_DPRP_EBS = False
VSAN_ENHANCED_URE_HANDLING = True
VSAN_FASTBOOT_V2 = False
VSAN_FILEANALYTICS = False
VSAN_FILESERVICE_AV = False
VSAN_FILESERVICE_CRX = False
VSAN_FILESERVICE_HOMEDIR = False
VSAN_FILESERVICE_KRB = True
VSAN_FILESERVICE_REPLICATION = False
VSAN_FILESERVICE_SHM = False
VSAN_FILESERVICE_SMB = True
VSAN_HARDWARE_MGMT = False
VSAN_HISTORICAL_HEALTH_REPORT = True
VSAN_MANAGED_PMEM = False
VSAN_MetadataElasticPolicy = True
VSAN_OBJ_HEALTH_V2 = False
VSAN_ObjectScrubConfig = False
VSAN_RdmaStretchedClusterSupport = False
VSAN_RDT_MUX2 = False
VSAN_REBUILD_TRIM = True
VSAN_SiteResiliency = True
VSAN_UNANIMOUS_DECISION = False
VSAN_UnplannedDelta = True
VSAN_V1_METADATA_RESILIENCY = False
VSAN_VCG_NOTIFICATION = False
VSAN_VMCP = False
VSAN_VpPlugin = True
VSAN_WITNESS_UPGRADE = True
VSAN_ZDOM = False
VslmStats = False
VSPHERE_DP = True
VSPHERE_DP_CODRAAS = False
VSPHERE_FD = False
VSTATS = True
VSTATS_SRE_HEALTH = False
VSTATS_VCSA_STORAGE_PROVIDERS = True
vVol_datastore_scalability = False
WCP_AppPlatform_InstallAPI = True
WCP_AppPlatform_Upgrade = True
WCP_AppPlatform_VcUiPlugins_Per_Cluster = True
WCP_CNS_File_Volume = True
WCP_DHCP = True
WCP_Enable_V2 = False
WCP_Enablement_Improvements = False
WCP_FaultDomains = False
WCP_GuestCluster = True
WCP_GuestCluster_Antrea = True
WCP_GuestCluster_NCP = False
WCP_GuestCluster_Update = True
WCP_GuestCluster_VCUI_Plugin = True
WCP_Instance_Storage = False
WCP_Integrated_AVI = False
WCP_Namespace_Network_Settings = True
WCP_Namespace_SelfService = True
WCP_Namespace_SelfService_Manage = True
WCP_NSX_Security_Policy = True
WCP_Observability_Logging = False
WCP_Pinniped_Integration = False
WCP_PMAN = True
WCP_PSP_ResourceCheck = True
WCP_Subscription_Licensing = True
WCP_Tanzu_Scale_Licensing = True
WCP_T1_PerNamespace = True
WCP_TMC_Proxy_Support = True
WCP_USE_VNVME_IN_POD_VM = True
WCP_VDPP_EMM_Improvements = False
WCP_VMC = True
WCP_VMC_PodVM = False
WCP_VMService = True
WCP_VMService_v1alpha2 = False
WCP_VMService_VMC = False
WCP_VMService_NamespaceTemplate = False
WCP_Workload_On_Vsphere_Networking_Avi = True
WCP_Workload_On_Vsphere_Networking_Day_Two = True
WCP_Workload_On_Vsphere_Networking_Upgrade = True
webRemoteDevice = True
webmks = True
XVC_Workflow_Security = False

# Use os.uname on vmkernel since platform.uname forks a child process.
try:
    USERWORLD = os.uname()[0] == 'VMkernel'
except:
    USERWORLD = False

if USERWORLD:
    TECH_PREVIEW_CFG_FILE = "/etc/vmware/vsphereFeatures/techPreview.cfg"
else:
    TECH_PREVIEW_CFG_FILE = os.path.join(os.environ.get('VMWARE_CFG_DIR', ""),
         'vsphereFeatures', 'techPreview.cfg')


def getFeatureNameList():
    return featureNameList

def computeDatetimeUtc():
    """
    Function that returns the date-time in UTC ISO 8601 format
    """
    return '%sZ' % datetime.utcnow().strftime('%Y-%m-%dT%H:%M:%S.%f')[:-3]

def print_stacktrace_and_exit(msg):
    logging.error(msg)
    logging.error("Printing stack trace before exiting")
    for line in traceback.format_stack():
        logging.error(line.strip())
    sys.exit(1)

def getAddDiscoveredHostToVlcmCluster():
    return AddDiscoveredHostToVlcmCluster

def getAppInfo_ConfigManager():
    return AppInfo_ConfigManager

def getARCTIC_H5C():
    return ARCTIC_H5C

def getARCTIC_VMWAREID_USER_ACCESS():
    return ARCTIC_VMWAREID_USER_ACCESS

def getAssignHwCompositeDev():
    return AssignHwCompositeDev

def getAssignHwPciLocality():
    return AssignHwPciLocality

def getAtlasAgentPlatformGW():
    return AtlasAgentPlatformGW

def getatlantic_unstable():
    return atlantic_unstable

def getAUTH_CSP_VMC_COMMERCIAL():
    return AUTH_CSP_VMC_COMMERCIAL

def getAUTH_STS_CERT_REFRESH():
    return AUTH_STS_CERT_REFRESH

def getAvsTpmMeasurements():
    return AvsTpmMeasurements

def getB2B_vmodl0():
    return B2B_vmodl0

def getB2B_vmodl1():
    return B2B_vmodl1

def getB2B_vmodl2():
    return B2B_vmodl2

def getB2B_vmodl3():
    return B2B_vmodl3

def getB2B_vmodl4():
    return B2B_vmodl4

def getBAUHAUS_CLUSTER_STORE():
    return BAUHAUS_CLUSTER_STORE

def getBAUHAUS_HOSTSYNC():
    return BAUHAUS_HOSTSYNC

def getbatchRenameSupport():
    return batchRenameSupport

def getBmcAccessLayer():
    return BmcAccessLayer

def getbmcInfo():
    return bmcInfo

def getbnxtnet_unstable():
    return bnxtnet_unstable

def getbnxtroce_unstable():
    return bnxtroce_unstable

def getbrcmfcoe_unstable():
    return brcmfcoe_unstable

def getCertificateAuthority():
    return CertificateAuthority

def getCertificateManagement():
    return CertificateManagement

def getClusterConfigManager():
    return ClusterConfigManager

def getClusterConfigManagerAutoBootstrap():
    return ClusterConfigManagerAutoBootstrap

def getClusterConfigManagerLive():
    return ClusterConfigManagerLive

def getClusterConfigManagerTransition():
    return ClusterConfigManagerTransition

def getClusteredEsx_V1():
    return ClusteredEsx_V1

def getClusterHclConvergence():
    return ClusterHclConvergence

def getClusterHclDiskDrivesStage2():
    return ClusterHclDiskDrivesStage2

def getClusterHclDiskDrivesStage3():
    return ClusterHclDiskDrivesStage3

def getClusterHclVsanNic():
    return ClusterHclVsanNic

def getClusterStore():
    return ClusterStore

def getCL_OVF_Deploy_Optimization():
    return CL_OVF_Deploy_Optimization

def getCL_SecurityPolicy():
    return CL_SecurityPolicy

def getCNS_ALL_SNAPSHOT():
    return CNS_ALL_SNAPSHOT

def getCNS_DISABLE_SYNC():
    return CNS_DISABLE_SYNC

def getCNS_NEW_SYNC():
    return CNS_NEW_SYNC

def getCNS_RELOCATE_VOLUME():
    return CNS_RELOCATE_VOLUME

def getCNS_PROP_COLLECTOR_DISPATCHER():
    return CNS_PROP_COLLECTOR_DISPATCHER

def getCNS_RELOCATE_COLD_VOLUME():
    return CNS_RELOCATE_COLD_VOLUME

def getConfigManagerHostAPIs():
    return ConfigManagerHostAPIs

def getConfigStoreStage2():
    return ConfigStoreStage2

def getCoreStorage_ConfigMgr():
    return CoreStorage_ConfigMgr

def getCPU_Scheduler_Info():
    return CPU_Scheduler_Info

def getdataService_pbm():
    return dataService_pbm

def getDCF():
    return DCF

def getDeltaMigrationXvc():
    return DeltaMigrationXvc

def getDistEsxClusterStoreManager():
    return DistEsxClusterStoreManager

def getDiskGroupVMC():
    return DiskGroupVMC

def getdnd():
    return dnd

def getDomEpdImprovements():
    return DomEpdImprovements

def getDriverBindParallel():
    return DriverBindParallel

def getDRS_LB_REASONCODE():
    return DRS_LB_REASONCODE

def getDS_FILE_MODIFICATION_UTC():
    return DS_FILE_MODIFICATION_UTC

def getDVX():
    return DVX

def getE2E_4KN():
    return E2E_4KN

def getelxnet_unstable():
    return elxnet_unstable

def getena_uens_unstable():
    return ena_uens_unstable

def getena_unstable():
    return ena_unstable

def getentityHealthStatus():
    return entityHealthStatus

def getEnvoyHostGateway():
    return EnvoyHostGateway

def getEnvoyOnESX():
    return EnvoyOnESX

def getEsxApiClients():
    return EsxApiClients

def getESXiLocalUsers():
    return ESXiLocalUsers

def getEsxIoAuth():
    return EsxIoAuth

def getEsxIoMgmt():
    return EsxIoMgmt

def getESXTelemetryGoldenMetrics():
    return ESXTelemetryGoldenMetrics

def geteSwap():
    return eSwap

def getESXConfigEncryptionAPIs():
    return ESXConfigEncryptionAPIs

def getEventsOrdering():
    return EventsOrdering

def getFastUpgrade():
    return FastUpgrade

def getFastUpgrade_SkipWhitelist():
    return FastUpgrade_SkipWhitelist

def getFastUpgrade_Vsan():
    return FastUpgrade_Vsan

def getFCD_CATALOG_HEALTH():
    return FCD_CATALOG_HEALTH

def getFCD_CATALOG_HEALTH_U4():
    return FCD_CATALOG_HEALTH_U4

def getFCD_VRA_SUPPORT():
    return FCD_VRA_SUPPORT

def getFedRAMP_VCSA():
    return FedRAMP_VCSA

def getFetchAuditRecords():
    return FetchAuditRecords

def getFileLockInfo_GSS34():
    return FileLockInfo_GSS34

def getfourKnStorageSupport():
    return fourKnStorageSupport

def getFT_DRS_METRO_CLUSTER():
    return FT_DRS_METRO_CLUSTER

def getFT_VBS_SUPPORT():
    return FT_VBS_SUPPORT

def getgfms():
    return gfms

def getgosCrashRemediation():
    return gosCrashRemediation

def getGateway_Observability():
    return Gateway_Observability

def getGraphicsDRS():
    return GraphicsDRS

def getguestDetailedData():
    return guestDetailedData

def getguestIntegrity():
    return guestIntegrity

def getGuestStore_ConfigManager():
    return GuestStore_ConfigManager

def getGuestStore_Stage1():
    return GuestStore_Stage1

def getGW_PLATFORM_UPDATE():
    return GW_PLATFORM_UPDATE

def getGW_PLATFORM_NOTIFICATIONS():
    return GW_PLATFORM_NOTIFICATIONS

def getHAConfigRetry():
    return HAConfigRetry

def getHAUpgradeStatus():
    return HAUpgradeStatus

def getHA_221_SDDC():
    return HA_221_SDDC

def getHA_CleanupDupVMs():
    return HA_CleanupDupVMs

def getHA_Clustering_SVC_V2_APIs():
    return HA_Clustering_SVC_V2_APIs

def getHA_ConfigStore():
    return HA_ConfigStore

def getHA_HostdAwareVMFailover():
    return HA_HostdAwareVMFailover

def getHBR_FAST_CONSOLIDATE():
    return HBR_FAST_CONSOLIDATE

def gethbr_nfc():
    return hbr_nfc

def gethostAccessManager():
    return hostAccessManager

def gethostCertificateManagement():
    return hostCertificateManagement

def getHostd_Authorization_CS():
    return Hostd_Authorization_CS

def getHostd_Config_CS():
    return Hostd_Config_CS

def getHostd_SecuritySettings_CS():
    return Hostd_SecuritySettings_CS

def getHostHealth_CS():
    return HostHealth_CS

def gethostProfiles():
    return hostProfiles

def gethostRemovalCheck():
    return hostRemovalCheck

def gethostVendorSpecificStatus():
    return hostVendorSpecificStatus

def getHPEngineParallel():
    return HPEngineParallel

def getHPEngineService():
    return HPEngineService

def getHPExtPlugins():
    return HPExtPlugins

def getHPP_ReservationSupport():
    return HPP_ReservationSupport

def gethwh():
    return hwh

def gethwh2_0():
    return hwh2_0

def gethwp():
    return hwp

def getHWv20():
    return HWv20

def getHWvFuture():
    return HWvFuture

def getHybridApplianceAPI():
    return HybridApplianceAPI

def getHybridVC():
    return HybridVC

def getHybridVC_MultiSDDC_GW():
    return HybridVC_MultiSDDC_GW

def getHybridVC_SyncaaS():
    return HybridVC_SyncaaS

def geti40en_unstable():
    return i40en_unstable

def getiavmd_unstable():
    return iavmd_unstable

def geticen_unstable():
    return icen_unstable

def getigbn_unstable():
    return igbn_unstable

def getInfravisor():
    return Infravisor

def getinotify():
    return inotify

def getionic_en_unstable():
    return ionic_en_unstable

def getirdman_unstable():
    return irdman_unstable

def getiser_unstable():
    return iser_unstable

def getixgben_unstable():
    return ixgben_unstable

def getKernelModule_ConfigStore():
    return KernelModule_ConfigStore

def getKernelOptions_ConfigStore():
    return KernelOptions_ConfigStore

def getKVStore_SecondaryKeys():
    return KVStore_SecondaryKeys

def getLangley_Future():
    return Langley_Future

def getliblsuv2_oem_hp_plugin():
    return liblsuv2_oem_hp_plugin

def getliblsuv2_oem_lenovo_plugin():
    return liblsuv2_oem_lenovo_plugin

def getLiveUpdate():
    return LiveUpdate

def getLLCSched():
    return LLCSched

def getLowLatencyVMPhase2():
    return LowLatencyVMPhase2

def getlpfc_unstable():
    return lpfc_unstable

def getLSI2PVSCSI():
    return LSI2PVSCSI

def getlsi_mr3_unstable():
    return lsi_mr3_unstable

def getlsi_msgpt35_unstable():
    return lsi_msgpt35_unstable

def getlsi_msgpt3_unstable():
    return lsi_msgpt3_unstable

def getLVM_DISKS_FSS():
    return LVM_DISKS_FSS

def getMAAS_GCP_IAM_INTEGRATION():
    return MAAS_GCP_IAM_INTEGRATION

def getMemoryTiering():
    return MemoryTiering

def getmultipleCapabilityRequirement():
    return multipleCapabilityRequirement

def getNativeKeyProvider():
    return NativeKeyProvider

def getNativeNVMEVVOLSupport():
    return NativeNVMEVVOLSupport

def getnativeSnapshot():
    return nativeSnapshot

def getNDU_Limited_Downtime():
    return NDU_Limited_Downtime

def getNDU_Stable_API():
    return NDU_Stable_API

def getne1000_unstable():
    return ne1000_unstable

def getnenic_unstable():
    return nenic_unstable

def getNestedPTsInVMKernel():
    return NestedPTsInVMKernel

def getNetwork_ConfigManager():
    return Network_ConfigManager

def getnetworkAwareDrs():
    return networkAwareDrs

def getNfcSessionInfo():
    return NfcSessionInfo

def getNFC_STREAM_OVER_VMOTION():
    return NFC_STREAM_OVER_VMOTION

def getnfnic_unstable():
    return nfnic_unstable

def getnhpsa_unstable():
    return nhpsa_unstable

def getnmlx4_core_unstable():
    return nmlx4_core_unstable

def getnmlx4_en_unstable():
    return nmlx4_en_unstable

def getnmlx4_rdma_unstable():
    return nmlx4_rdma_unstable

def getnmlx5_core_unstable():
    return nmlx5_core_unstable

def getnmlx5_rdma_unstable():
    return nmlx5_rdma_unstable

def getnmlxbf_gige_unstable():
    return nmlxbf_gige_unstable

def getNsxLiveUpdate():
    return NsxLiveUpdate

def getNSX_Integrated():
    return NSX_Integrated

def getnsx_uens_u2():
    return nsx_uens_u2

def getnsx_uens_default():
    return nsx_uens_default

def getntg3_unstable():
    return ntg3_unstable

def getnvmerdma_unstable():
    return nvmerdma_unstable

def getNVMeVVols3_VASA4():
    return NVMeVVols3_VASA4

def getnvme_pcie_unstable():
    return nvme_pcie_unstable

def getnvme_stats():
    return nvme_stats

def getnvmxnet3_unstable():
    return nvmxnet3_unstable

def getocmSupportedForReconfigure():
    return ocmSupportedForReconfigure

def getPANDORA_REMOVAL():
    return PANDORA_REMOVAL

def getpbmDataProvider():
    return pbmDataProvider

def getpciDeviceExt():
    return pciDeviceExt

def getpciDpcQuirks():
    return pciDpcQuirks

def getpcieDirectP2P():
    return pcieDirectP2P

def getpciSriovExtendedID():
    return pciSriovExtendedID

def getpciSriovPerDeviceMaxVfs():
    return pciSriovPerDeviceMaxVfs

def getPersonalityManagerDepotDeletion():
    return PersonalityManagerDepotDeletion

def getPersonalityManagerErrorReport():
    return PersonalityManagerErrorReport

def getPersonalityManagerESXio():
    return PersonalityManagerESXio

def getPersonalityManagerFDAwareSolutionApply():
    return PersonalityManagerFDAwareSolutionApply

def getPersonalityManagerHWCapabilityModule():
    return PersonalityManagerHWCapabilityModule

def getPersonalityManagerRecoEngineStage2():
    return PersonalityManagerRecoEngineStage2

def getPersonalityManagerSoftwareInternalTest():
    return PersonalityManagerSoftwareInternalTest

def getPersonalityManagerSoftwareSolutions():
    return PersonalityManagerSoftwareSolutions

def getPersonalityManagerSoftwareSolutionsNsx():
    return PersonalityManagerSoftwareSolutionsNsx

def getPersonalityManagerStage2():
    return PersonalityManagerStage2

def getPersonalityManagerStagingV1():
    return PersonalityManagerStagingV1

def getPersonalityManagerVMC():
    return PersonalityManagerVMC

def getPersonalityManagerVMC_Witness():
    return PersonalityManagerVMC_Witness

def getPktcap_RCF():
    return Pktcap_RCF

def getPMemDLC():
    return PMemDLC

def getPMemHA_V1():
    return PMemHA_V1

def getPMemIndepSnapshot():
    return PMemIndepSnapshot

def getPMemV2():
    return PMemV2

def getpmem_nfc():
    return pmem_nfc

def getPodVMOnVDS():
    return PodVMOnVDS

def getpolicyIntrospect():
    return policyIntrospect

def getPOSIXDomainSockets():
    return POSIXDomainSockets

def getpr1429825():
    return pr1429825

def getpr1803450():
    return pr1803450

def getprofileDetails():
    return profileDetails

def getProvisioningEventRefresh():
    return ProvisioningEventRefresh

def getqcnic_unstable():
    return qcnic_unstable

def getqedentv_unstable():
    return qedentv_unstable

def getqedi():
    return qedi

def getqedf():
    return qedf

def getqedrntv_unstable():
    return qedrntv_unstable

def getqfle3f_unstable():
    return qfle3f_unstable

def getqfle3i_unstable():
    return qfle3i_unstable

def getqfle3_unstable():
    return qfle3_unstable

def getqflge_unstable():
    return qflge_unstable

def getqlnativefc_unstable():
    return qlnativefc_unstable

def getqueryAllProviders():
    return queryAllProviders

def getQuickBoot_TPM():
    return QuickBoot_TPM

def getQuickLaunch_Drivers():
    return QuickLaunch_Drivers

def getQuickLaunch_KernelPreload():
    return QuickLaunch_KernelPreload

def getRbdCustomHostCerts():
    return RbdCustomHostCerts

def getrdmahl_unstable():
    return rdmahl_unstable

def getRDU_LVM_Integration():
    return RDU_LVM_Integration

def getRebootReasonTool():
    return RebootReasonTool

def getRelationshipManager():
    return RelationshipManager

def getresetportstatistics():
    return resetportstatistics

def getsandboxd_cps():
    return sandboxd_cps

def getSEV_SNP():
    return SEV_SNP

def getsfvmk_unstable():
    return sfvmk_unstable

def getSGX_MPA_HostReg():
    return SGX_MPA_HostReg

def getSGX_MPA_VMCheck():
    return SGX_MPA_VMCheck

def getSHA256_Mode():
    return SHA256_Mode

def getsmartnic_network():
    return smartnic_network

def getsmartnic_vc():
    return smartnic_vc

def getsmartpqi_unstable():
    return smartpqi_unstable

def getsmsInfrastructure():
    return smsInfrastructure

def getSoftNUMA():
    return SoftNUMA

def getspbmApplyProfileExt():
    return spbmApplyProfileExt

def getSPBM_DISK_PROV_VIA_POLICY():
    return SPBM_DISK_PROV_VIA_POLICY

def getspbmFetchEntityHealthStatusExt():
    return spbmFetchEntityHealthStatusExt

def getspbmHCIMeshIntegration():
    return spbmHCIMeshIntegration

def getspbmParameterizedProfiles():
    return spbmParameterizedProfiles

def getSpsDebugAPIs():
    return SpsDebugAPIs

def getSRE_Health():
    return SRE_Health

def getSRIOVValidNumVFs():
    return SRIOVValidNumVFs

def getStatsStreaming():
    return StatsStreaming

def getSTSMultitoken():
    return STSMultitoken

def getSvcAccountMgmt():
    return SvcAccountMgmt

def getTaggingPluginForIPM():
    return TaggingPluginForIPM

def getTDX():
    return TDX

def getThunderPciDevices():
    return ThunderPciDevices

def getThunderPciDevices_TKG_PassThrough():
    return ThunderPciDevices_TKG_PassThrough

def getTimeSysCRX():
    return TimeSysCRX

def gettoolsOffHost():
    return toolsOffHost

def getTools_Update_Health():
    return Tools_Update_Health

def getTLSCertSubscription():
    return TLSCertSubscription

def getTrustAuthority_V4():
    return TrustAuthority_V4

def getTrustManagement():
    return TrustManagement

def getUPITHostCapability():
    return UPITHostCapability

def getUSB_NIC():
    return USB_NIC

def getUSB_PTSwitch_ConfigManager():
    return USB_PTSwitch_ConfigManager

def getUserLevelMonitor():
    return UserLevelMonitor

def getVADP_NVMEQuiescedSnapshot():
    return VADP_NVMEQuiescedSnapshot

def getVapiPowerSvc():
    return VapiPowerSvc

def getVAPI_PROVIDER_FILE_REG():
    return VAPI_PROVIDER_FILE_REG

def getVAPI_TAGGING_SPBM():
    return VAPI_TAGGING_SPBM

def getVASA_TargetGroupName():
    return VASA_TargetGroupName

def getvcAgnosticCompatCheck():
    return vcAgnosticCompatCheck

def getVCDP_NestedFilters():
    return VCDP_NestedFilters

def getVCDP_SmartSearch():
    return VCDP_SmartSearch

def getVCLS_DatastoreReconfigure():
    return VCLS_DatastoreReconfigure

def getVCProfiles_Apply_DS():
    return VCProfiles_Apply_DS

def getVCProfiles_UI_ConfigMgmt():
    return VCProfiles_UI_ConfigMgmt

def getVCProfilesVsphereUiConfig():
    return VCProfilesVsphereUiConfig

def getVCSA_CONTAINERS():
    return VCSA_CONTAINERS

def getVCSA_Hardening():
    return VCSA_Hardening

def getVCSA_WS1_CONTAINERS():
    return VCSA_WS1_CONTAINERS

def getVCSA_WS1_INTEGRATION():
    return VCSA_WS1_INTEGRATION

def getVCSASideCarProxy():
    return VCSASideCarProxy

def getVCSOF_173():
    return VCSOF_173

def getVC_EnableSsoResilienceFlag():
    return VC_EnableSsoResilienceFlag

def getVC_FIPS():
    return VC_FIPS

def getVC_FIPS_SIDECAR():
    return VC_FIPS_SIDECAR

def getVC_JAVA_FIPS():
    return VC_JAVA_FIPS

def getVC_TICKET_AUTH_FILE_TRANSFER():
    return VC_TICKET_AUTH_FILE_TRANSFER

def getVC_VAPI_GuestCustomization2():
    return VC_VAPI_GuestCustomization2

def getVC_VAPI_JavaShimRemoval1():
    return VC_VAPI_JavaShimRemoval1

def getVCM():
    return VCM

def getVCReportMissingPrivileges():
    return VCReportMissingPrivileges

def getVCReportRequestedPrivileges():
    return VCReportRequestedPrivileges

def getvdcs():
    return vdcs

def getvdtc_esx():
    return vdtc_esx

def getvdtc_esx_core():
    return vdtc_esx_core

def getvdtc_hostd():
    return vdtc_hostd

def getvdtc_pyVmomi_client():
    return vdtc_pyVmomi_client

def getvdtc_vpxa():
    return vdtc_vpxa

def getVFlash_Removal():
    return VFlash_Removal

def getvHT():
    return vHT

def getVirtualTopo():
    return VirtualTopo

def getVLCM_HA_NewLockingStrategy():
    return VLCM_HA_NewLockingStrategy

def getVLCM_RevisedLockingStrategy():
    return VLCM_RevisedLockingStrategy

def getVLCM_TelemetryErrorSupport():
    return VLCM_TelemetryErrorSupport

def getVMAFD_ESX():
    return VMAFD_ESX

def getVmcExternalStorageSupport():
    return VmcExternalStorageSupport

def getVMCG_AUTO_UPDATE():
    return VMCG_AUTO_UPDATE

def getVmciMultiArch():
    return VmciMultiArch

def getvmcManagementProfile():
    return vmcManagementProfile

def getvmcps():
    return vmcps

def getVMK_USB_3_2_SPEC_COMPLIANCE():
    return VMK_USB_3_2_SPEC_COMPLIANCE

def getVmkapps_ConfigManager():
    return Vmkapps_ConfigManager

def getVmkapps_ConfigManagerAdvCfg():
    return Vmkapps_ConfigManagerAdvCfg

def getVmkapps_ConfigManagerAdvCfgStage2():
    return Vmkapps_ConfigManagerAdvCfgStage2

def getVmkapps_ConfigManagerPTP():
    return Vmkapps_ConfigManagerPTP

def getVmkapps_ConfigManagerScratchConfig():
    return Vmkapps_ConfigManagerScratchConfig

def getVmkapps_ConfigManagerSsh():
    return Vmkapps_ConfigManagerSsh

def getVmkapps_ConfigManagerStage2():
    return Vmkapps_ConfigManagerStage2

def getVmkapps_ConfigManagerSyslog():
    return Vmkapps_ConfigManagerSyslog

def getVmkapps_snmpv3LK():
    return Vmkapps_snmpv3LK

def getVmkapps_timecfg():
    return Vmkapps_timecfg

def getVMcrypt3_KeyCustomAttribute():
    return VMcrypt3_KeyCustomAttribute

def getVMcryptNext():
    return VMcryptNext

def getVMcrypt_IntegrityProtection():
    return VMcrypt_IntegrityProtection

def getVMcrypt_OnlineVMEncryption():
    return VMcrypt_OnlineVMEncryption

def getVMcrypt_V4():
    return VMcrypt_V4

def getVMDIR_SimplifiedReplication():
    return VMDIR_SimplifiedReplication

def getVMIOP_DEVICE_HANDOFF():
    return VMIOP_DEVICE_HANDOFF

def getVMIOP_MIGRATE_PRECOPY():
    return VMIOP_MIGRATE_PRECOPY

def getvMMR():
    return vMMR

def getvmknvmevvol():
    return vmknvmevvol

def getvmknvme_enhance_iosplit():
    return vmknvme_enhance_iosplit

def getvmksdhci():
    return vmksdhci

def getvmMisc():
    return vmMisc

def getVMNameSpace():
    return VMNameSpace

def getVMODL_FSS():
    return VMODL_FSS

def getVMODL_JOAP_VMOMI():
    return VMODL_JOAP_VMOMI

def getvmodlVasaDataService():
    return vmodlVasaDataService

def getvmodlvsanVpxd():
    return vmodlvsanVpxd

def getvmsyslogd2():
    return vmsyslogd2

def getVMWARE_B2B():
    return VMWARE_B2B

def getvmw_ahci_unstable():
    return vmw_ahci_unstable

def getVMXStats():
    return VMXStats

def getvmxnet3UPT():
    return vmxnet3UPT

def getVM_CLONE_SWITCH_HOST_EMM():
    return VM_CLONE_SWITCH_HOST_EMM

def getVM_Customization_Cloudinit_Data():
    return VM_Customization_Cloudinit_Data

def getVM_Customization_Telemetry():
    return VM_Customization_Telemetry

def getVM_OP_NOTIFICATION_TO_APP():
    return VM_OP_NOTIFICATION_TO_APP

def getVNVME_Clustering():
    return VNVME_Clustering

def getVQAT():
    return VQAT

def getVRDMA_ASYNC_POST():
    return VRDMA_ASYNC_POST

def getVSAN2_AwareDrs():
    return VSAN2_AwareDrs

def getVSAN2_CLOM():
    return VSAN2_CLOM

def getVSAN2_DOM():
    return VSAN2_DOM

def getVSAN2_Encryption():
    return VSAN2_Encryption

def getVSAN2_NativeSnapshot():
    return VSAN2_NativeSnapshot

def getVSAN2_Policy():
    return VSAN2_Policy

def getVSAN2_SingleTier():
    return VSAN2_SingleTier

def getVSAN2_Compression():
    return VSAN2_Compression

def getVSAN2_Configure():
    return VSAN2_Configure

def getvsanAssociation():
    return vsanAssociation

def getvsanHealthInCompliance():
    return vsanHealthInCompliance

def getvsanObjectSupport():
    return vsanObjectSupport

def getVSAN_CMMDS_ARENA_COMPRESSION():
    return VSAN_CMMDS_ARENA_COMPRESSION

def getVSAN_DOM_OWNER_REBALANCE():
    return VSAN_DOM_OWNER_REBALANCE

def getVSAN_ComputeOnlyClient():
    return VSAN_ComputeOnlyClient

def getVSAN_ConfigManager():
    return VSAN_ConfigManager

def getVSAN_CoreDump():
    return VSAN_CoreDump

def getVSAN_CRYPTO_SG_API():
    return VSAN_CRYPTO_SG_API

def getVSAN_DeltaCompEnsureDurability():
    return VSAN_DeltaCompEnsureDurability

def getVSAN_DEV_MODE():
    return VSAN_DEV_MODE

def getVSAN_DgBasedReplication():
    return VSAN_DgBasedReplication

def getVSAN_DIRECT_CAP_POLICY():
    return VSAN_DIRECT_CAP_POLICY

def getVSAN_DIRECT_COMPUTE_ONLY_CLUSTER():
    return VSAN_DIRECT_COMPUTE_ONLY_CLUSTER

def getVSAN_DIRECT_DISK_DECOMMISSION():
    return VSAN_DIRECT_DISK_DECOMMISSION

def getVSAN_DIRECT_DISK_DECOM_E2E():
    return VSAN_DIRECT_DISK_DECOM_E2E

def getVSAN_DPAP():
    return VSAN_DPAP

def getVSAN_DPRP():
    return VSAN_DPRP

def getVSAN_DPRP_EBS():
    return VSAN_DPRP_EBS

def getVSAN_ENHANCED_URE_HANDLING():
    return VSAN_ENHANCED_URE_HANDLING

def getVSAN_FASTBOOT_V2():
    return VSAN_FASTBOOT_V2

def getVSAN_FILEANALYTICS():
    return VSAN_FILEANALYTICS

def getVSAN_FILESERVICE_AV():
    return VSAN_FILESERVICE_AV

def getVSAN_FILESERVICE_CRX():
    return VSAN_FILESERVICE_CRX

def getVSAN_FILESERVICE_HOMEDIR():
    return VSAN_FILESERVICE_HOMEDIR

def getVSAN_FILESERVICE_KRB():
    return VSAN_FILESERVICE_KRB

def getVSAN_FILESERVICE_REPLICATION():
    return VSAN_FILESERVICE_REPLICATION

def getVSAN_FILESERVICE_SHM():
    return VSAN_FILESERVICE_SHM

def getVSAN_FILESERVICE_SMB():
    return VSAN_FILESERVICE_SMB

def getVSAN_HARDWARE_MGMT():
    return VSAN_HARDWARE_MGMT

def getVSAN_HISTORICAL_HEALTH_REPORT():
    return VSAN_HISTORICAL_HEALTH_REPORT

def getVSAN_MANAGED_PMEM():
    return VSAN_MANAGED_PMEM

def getVSAN_MetadataElasticPolicy():
    return VSAN_MetadataElasticPolicy

def getVSAN_OBJ_HEALTH_V2():
    return VSAN_OBJ_HEALTH_V2

def getVSAN_ObjectScrubConfig():
    return VSAN_ObjectScrubConfig

def getVSAN_RdmaStretchedClusterSupport():
    return VSAN_RdmaStretchedClusterSupport

def getVSAN_RDT_MUX2():
    return VSAN_RDT_MUX2

def getVSAN_REBUILD_TRIM():
    return VSAN_REBUILD_TRIM

def getVSAN_SiteResiliency():
    return VSAN_SiteResiliency

def getVSAN_UNANIMOUS_DECISION():
    return VSAN_UNANIMOUS_DECISION

def getVSAN_UnplannedDelta():
    return VSAN_UnplannedDelta

def getVSAN_V1_METADATA_RESILIENCY():
    return VSAN_V1_METADATA_RESILIENCY

def getVSAN_VCG_NOTIFICATION():
    return VSAN_VCG_NOTIFICATION

def getVSAN_VMCP():
    return VSAN_VMCP

def getVSAN_VpPlugin():
    return VSAN_VpPlugin

def getVSAN_WITNESS_UPGRADE():
    return VSAN_WITNESS_UPGRADE

def getVSAN_ZDOM():
    return VSAN_ZDOM

def getVslmStats():
    return VslmStats

def getVSPHERE_DP():
    return VSPHERE_DP

def getVSPHERE_DP_CODRAAS():
    return VSPHERE_DP_CODRAAS

def getVSPHERE_FD():
    return VSPHERE_FD

def getVSTATS():
    return VSTATS

def getVSTATS_SRE_HEALTH():
    return VSTATS_SRE_HEALTH

def getVSTATS_VCSA_STORAGE_PROVIDERS():
    return VSTATS_VCSA_STORAGE_PROVIDERS

def getvVol_datastore_scalability():
    return vVol_datastore_scalability

def getWCP_AppPlatform_InstallAPI():
    return WCP_AppPlatform_InstallAPI

def getWCP_AppPlatform_Upgrade():
    return WCP_AppPlatform_Upgrade

def getWCP_AppPlatform_VcUiPlugins_Per_Cluster():
    return WCP_AppPlatform_VcUiPlugins_Per_Cluster

def getWCP_CNS_File_Volume():
    return WCP_CNS_File_Volume

def getWCP_DHCP():
    return WCP_DHCP

def getWCP_Enable_V2():
    return WCP_Enable_V2

def getWCP_Enablement_Improvements():
    return WCP_Enablement_Improvements

def getWCP_FaultDomains():
    return WCP_FaultDomains

def getWCP_GuestCluster():
    return WCP_GuestCluster

def getWCP_GuestCluster_Antrea():
    return WCP_GuestCluster_Antrea

def getWCP_GuestCluster_NCP():
    return WCP_GuestCluster_NCP

def getWCP_GuestCluster_Update():
    return WCP_GuestCluster_Update

def getWCP_GuestCluster_VCUI_Plugin():
    return WCP_GuestCluster_VCUI_Plugin

def getWCP_Instance_Storage():
    return WCP_Instance_Storage

def getWCP_Integrated_AVI():
    return WCP_Integrated_AVI

def getWCP_Namespace_Network_Settings():
    return WCP_Namespace_Network_Settings

def getWCP_Namespace_SelfService():
    return WCP_Namespace_SelfService

def getWCP_Namespace_SelfService_Manage():
    return WCP_Namespace_SelfService_Manage

def getWCP_NSX_Security_Policy():
    return WCP_NSX_Security_Policy

def getWCP_Observability_Logging():
    return WCP_Observability_Logging

def getWCP_Pinniped_Integration():
    return WCP_Pinniped_Integration

def getWCP_PMAN():
    return WCP_PMAN

def getWCP_PSP_ResourceCheck():
    return WCP_PSP_ResourceCheck

def getWCP_Subscription_Licensing():
    return WCP_Subscription_Licensing

def getWCP_Tanzu_Scale_Licensing():
    return WCP_Tanzu_Scale_Licensing

def getWCP_T1_PerNamespace():
    return WCP_T1_PerNamespace

def getWCP_TMC_Proxy_Support():
    return WCP_TMC_Proxy_Support

def getWCP_USE_VNVME_IN_POD_VM():
    return WCP_USE_VNVME_IN_POD_VM

def getWCP_VDPP_EMM_Improvements():
    return WCP_VDPP_EMM_Improvements

def getWCP_VMC():
    return WCP_VMC

def getWCP_VMC_PodVM():
    return WCP_VMC_PodVM

def getWCP_VMService():
    return WCP_VMService

def getWCP_VMService_v1alpha2():
    return WCP_VMService_v1alpha2

def getWCP_VMService_VMC():
    return WCP_VMService_VMC

def getWCP_VMService_NamespaceTemplate():
    return WCP_VMService_NamespaceTemplate

def getWCP_Workload_On_Vsphere_Networking_Avi():
    return WCP_Workload_On_Vsphere_Networking_Avi

def getWCP_Workload_On_Vsphere_Networking_Day_Two():
    return WCP_Workload_On_Vsphere_Networking_Day_Two

def getWCP_Workload_On_Vsphere_Networking_Upgrade():
    return WCP_Workload_On_Vsphere_Networking_Upgrade

def getwebRemoteDevice():
    return webRemoteDevice

def getwebmks():
    return webmks

def getXVC_Workflow_Security():
    return XVC_Workflow_Security

def create_dict_from_file(fileName, delimiter='='):
    with codecs.open(fileName, 'r', 'utf-8') as f:
        d = {}
        for line in f:
            key = line.rstrip().split(delimiter, 1)[0].strip()
            val = line.rstrip().split(delimiter, 1)[1].strip()
            d[key] = val
    return d

def read_feature_state(feature_state_dict, feature, state=None):
    if feature in feature_state_dict:
        val = feature_state_dict[feature]
        if val is not None:
            if val.lower() == 'enabled':
                state = True
            elif val.lower() == 'disabled':
                state = False

    return state

def print_features():
    pass

def set_feature_state(feature_state_dict):
    pass

def setTechPreviewFromCfg():
    tech_preview_dict = create_dict_from_file(TECH_PREVIEW_CFG_FILE)

def init(enableLogging=True):
    pass

    try:
        setTechPreviewFromCfg()
    except Exception as exc:
        logging.warning("Could not read config file: %s, using default "
            "(disabled) for all tech preview features.\n Error: %s" %
            (TECH_PREVIEW_CFG_FILE, str(exc)))
