#!/bin/bash
# PR 2574354 Backup non default certs from the current JRE Cert Store. Will be restored in the
# JRE cert store on the new JRE installation

JRE_1_8_222_DEFAULT_CERTS=(
"securetrustca [jdk]"
"buypassclass3ca [jdk]"
"quovadisrootca1g3 [jdk]"
"godaddyclass2ca [jdk]"
"cert_116_amazon_root_ca_4116"
"cert_32_secure_global_ca32"
"digicerthighassuranceevrootca [jdk]"
"cert_36_oiste_wisekey_global_root_ga_ca36"
"cert_112_ac_raiz_fnmt_rcm112"
"cert_136_emsign_root_ca___g1136"
"cert_48_netlock_arany__class_gold__f_tan_s_tv_ny48"
"cert_69_hellenic_academic_and_research_institutions_rootca_201169"
"geotrustprimarycag2 [jdk]" "verisignclass3g2ca [jdk]"
"geotrustprimarycag3 [jdk]" "digicertassuredidg2 [jdk]"
"ttelesecglobalrootclass2ca [jdk]" "starfieldclass2ca [jdk]"
"cert_118_tubitak_kamu_sm_ssl_kok_sertifikasi___surum_1118"
"cert_80_twca_global_root_ca80" "cert_55_izenpe_com55"
"cert_99_staat_der_nederlanden_ev_root_ca99"
"digicertglobalrootca [jdk]"
"cert_78_ca_disig_root_r278"
"cert_119_gdca_trustauth_r5_root119"
"affirmtrustpremiumeccca [jdk]"
"cert_123_ssl_com_root_certification_authority_rsa123"
"globalsignr2ca [jdk]"
"cert_106_oiste_wisekey_global_root_gb_ca106"
"soneraclass2ca [jdk]"
"cert_125_ssl_com_ev_root_certification_authority_rsa_r2125"
"cert_71_trustis_fps_root_ca71"
"cert_109_hellenic_academic_and_research_institutions_rootca_2015109"
"geotrustprimaryca [jdk]"
"cert_79_accvraiz179"
"starfieldservicesrootg2ca [jdk]"
"geotrustglobalca [jdk]"
"cert_34_network_solutions_certificate_authority34"
"cert_130_gts_root_r2130"
"cert_51_securesign_rootca1151"
"identrustpublicca [jdk]"
"camerfirmachambersca [jdk]"
"cert_37_certigna37"
"camerfirmachambersignca [jdk]"
"cert_75_ee_certification_centre_root_ca75"
"xrampglobalca [jdk]"
"verisigntsaca [jdk]"
"cert_135_certigna_root_ca135"
"thawtepremiumserverca [jdk]"
"verisignclass3ca [jdk]"
"cert_98_staat_der_nederlanden_root_ca___g398"
"quovadisrootca2g3 [jdk]"
"digicertglobalrootg2 [jdk]"
"certumtrustednetworkca [jdk]"
"digicertglobalrootg3 [jdk]"
"cert_33_comodo_certification_authority33"
"comodoaaaca [jdk]"
"camerfirmachamberscommerceca [jdk]"
"cert_84_atos_trustedroot_201184"
"verisignclass3g3ca [jdk]"
"cert_134_uca_extended_validation_root134"
"addtrustexternalca [jdk]"
"ttelesecglobalrootclass3ca [jdk]"
"cert_126_ssl_com_ev_root_certification_authority_ecc126"
"dtrustclass3ca2ev [jdk]"
"cert_104_cfca_ev_root104"
"cert_122_trustcor_eca_1122"
"baltimorecybertrustca [jdk]"
"cert_66_twca_root_certification_authority66"
"geotrustuniversalca [jdk]"
"cert_124_ssl_com_root_certification_authority_ecc124"
"thawteprimaryrootca [jdk]"
"globalsignr3ca [jdk]"
"dtrustclass3ca2 [jdk]"
"teliasonerarootcav1 [jdk]"
"cert_132_gts_root_r4132"
"comodorsaca [jdk]"
"cert_10_geotrust_universal_ca_210"
"swisssignplatinumg2ca [jdk]"
"cert_117_luxtrust_global_root_2117"
"thawteprimaryrootcag2 [jdk]"
"comodoeccca [jdk]"
"thawteprimaryrootcag3 [jdk]"
"cert_105_certinomis___root_ca105"
"identrustcommercial [jdk]"
"chunghwaepkirootca [jdk]"
"cert_108_certum_trusted_network_ca_2108"
"identrustdstx3 [jdk]" "entrustevca [jdk]"
"cert_121_trustcor_rootcert_ca_2121"
"addtrustclass1ca [jdk]"
"cert_49_staat_der_nederlanden_root_ca___g249"
"digicertassuredidrootca [jdk]"
"cert_129_gts_root_r1129"
"keynectisrootca [jdk]"
"cert_113_amazon_root_ca_1113"
"globalsignrootcar6 [jdk]"
"cert_41_certsign_root_ca41"
"affirmtrustpremiumca [jdk]"
"cert_52_microsec_e_szigno_root_ca_200952"
"verisignuniversalrootca [jdk]"
"buypassclass2ca [jdk]"
"entrust2048ca [jdk]"
"quovadisrootca3g3 [jdk]"
"digicerttrustedrootg4 [jdk]"
"affirmtrustcommercialca [jdk]"
"actalisauthenticationrootca [jdk]"
"cert_20_taiwan_grca20"
"cert_82_e_tugra_certification_authority82"
"globalsigneccrootcar5 [jdk]"
"cert_50_hongkong_post_root_ca_150"
"secomscrootca2 [jdk]"
"swisssignsilverg2ca [jdk]"
"verisignclass3g4ca [jdk]"
"cert_137_emsign_ecc_root_ca___g3137"
"cert_110_hellenic_academic_and_research_institutions_ecc_rootca_2015110"
"quovadisrootca2 [jdk]"
"globalsigneccrootcar4 [jdk]"
"quovadisrootca3 [jdk]"
"entrustrootcaec1 [jdk]"
"cert_114_amazon_root_ca_2114"
"affirmtrustnetworkingca [jdk]"
"luxtrustglobalrootca [jdk]"
"quovadisrootca [jdk]"
"secomscrootca1 [jdk]"
"cert_39_cybertrust_global_root39"
"godaddyrootg2ca [jdk]"
"entrustrootcag2 [jdk]"
"cert_68_ec_acc68"
"cert_128_oiste_wisekey_global_root_gc_ca128"
"letsencryptisrgx1 [jdk]"
"cert_131_gts_root_r3131"
"usertrustrsaca [jdk]"
"cert_107_szafir_root_ca2107"
"swisssigngoldg2ca [jdk]"
"cert_138_emsign_root_ca___c1138"
"addtrustqualifiedca [jdk]"
"starfieldrootg2ca [jdk]"
"globalsignca [jdk]"
"usertrusteccca [jdk]"
"cert_139_emsign_ecc_root_ca___c3139"
"cert_120_trustcor_rootcert_ca_1120"
"cert_133_uca_global_g2_root133"
"cert_115_amazon_root_ca_3115"
"verisignclass2g2ca [jdk]"
"certumca [jdk]"
"cert_54_autoridad_de_certificacion_firmaprofesional_cif_a6263406854"
"digicertassuredidg3 [jdk]"
"verisignclass3g5ca [jdk]"
)


isDefaultCert () {
    for item in "${JRE_1_8_222_DEFAULT_CERTS[@]}"
    do
        if [ $1 == $item ]; then
        return 0
        fi
    done
    return 1
}


if [ ! -d /tmp/certs ] && [ "`/usr/java/jre-vmware/bin/java -version 2>&1 | grep 1.8.0_222`" ]; then
    echo "Attempting to back up non default certs from the JRE store..."

    mkdir -p /tmp/certs
    all_certs=$(keytool -list -v -noprompt -storepass changeit -keystore /usr/java/jre-vmware/lib/security/cacerts | grep Alias | cut -d ":" -f2 | sed "s/$/:/" )
    export IFS=":"
    for word in $all_certs; do
        cert_alias=$(echo -e "${word:1}" | sed "s/^[[:blank:]]*//")
        if isDefaultCert $cert_alias; then
            echo "skipping default cert $cert_alias"
        else
            echo "backing up $cert_alias"
            keytool -export -rfc -alias "$cert_alias" -file /tmp/certs/"$cert_alias.cer" -noprompt -storepass changeit -keystore /usr/java/jre-vmware/lib/security/cacerts
        fi
    done

else
    echo "not backing up certs from JRE store..."
fi
